/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.engine.Connection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class AmqpBrokerRequestedHearbeatsTest
extends AmqpClientTestSupport {
    private final int TEST_IDLE_TIMEOUT = 1000;
    @Parameter(index=0)
    public boolean useOverride;

    @Parameters(name="useOverride={0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    @Override
    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
        if (!this.useOverride) {
            params.put("amqpIdleTimeout", "1000");
        }
    }

    @Override
    protected void addConfiguration(ActiveMQServer server) {
        server.getConfiguration().setConnectionTtlCheckInterval(333L);
        if (this.useOverride) {
            server.getConfiguration().setConnectionTTLOverride(1000L);
        }
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testBrokerSendsHalfConfiguredIdleTimeout() throws Exception {
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                Assertions.assertEquals((int)500, (int)connection.getTransport().getRemoteIdleTimeout(), (String)"Broker did not send half the idle timeout");
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        Assertions.assertNotNull((Object)connection);
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testBrokerSendsHalfConfiguredIdleTimeoutWhenClientSendsTimeout() throws Exception {
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Connection connection) {
                Assertions.assertEquals((int)500, (int)connection.getTransport().getRemoteIdleTimeout(), (String)"Broker did not send half the idle timeout");
            }
        });
        AmqpConnection connection = this.addConnection(client.createConnection());
        connection.setIdleTimeout(4000);
        Assertions.assertNotNull((Object)connection);
        connection.connect();
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testClientWithoutHeartbeatsGetsDropped() throws Exception {
        CountDownLatch disconnected = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        AmqpConnection connection = this.addConnection(client.createConnection());
        Assertions.assertNotNull((Object)connection);
        connection.setIdleProcessingDisabled(true);
        connection.setListener(ex -> disconnected.countDown());
        connection.connect();
        Assertions.assertEquals((int)1, (int)this.server.getConnectionCount());
        Assertions.assertTrue((boolean)disconnected.await(30L, TimeUnit.SECONDS));
        connection.close();
        Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testClientWithHeartbeatsStaysAlive() throws Exception {
        CountDownLatch disconnected = new CountDownLatch(1);
        AmqpClient client = this.createAmqpClient();
        Assertions.assertNotNull((Object)client);
        AmqpConnection connection = this.addConnection(client.createConnection());
        Assertions.assertNotNull((Object)connection);
        connection.setListener(ex -> disconnected.countDown());
        connection.connect();
        Assertions.assertEquals((int)1, (int)this.server.getConnectionCount());
        Assertions.assertFalse((boolean)disconnected.await(5L, TimeUnit.SECONDS));
        connection.close();
        Wait.assertEquals((int)0, () -> ((ActiveMQServer)this.server).getConnectionCount());
    }
}

