/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMapMessageWrapper;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class AmqpManagementTest
extends AmqpClientTestSupport {
    private static final Binary BINARY_CORRELATION_ID = new Binary("mystring".getBytes(StandardCharsets.UTF_8));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testManagementQueryOverAMQP() throws Throwable {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            String destinationAddress = this.getQueueName(1);
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender("activemq.management");
            AmqpReceiver receiver = session.createReceiver(destinationAddress);
            receiver.flow(10);
            AmqpMessage request = new AmqpMessage();
            request.setApplicationProperty("_AMQ_ResourceName", "broker");
            request.setApplicationProperty("_AMQ_OperationName", "getQueueNames");
            request.setReplyToAddress(destinationAddress);
            request.setText("[]");
            sender.send(request);
            AmqpMessage response = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)response);
            Assertions.assertNotNull((Object)response);
            Section section = response.getWrappedMessage().getBody();
            Assertions.assertTrue((boolean)(section instanceof AmqpValue));
            Object value = ((AmqpValue)section).getValue();
            Assertions.assertTrue((boolean)(value instanceof String));
            Assertions.assertTrue((((String)value).length() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)((String)value).contains(destinationAddress));
            response.accept();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testUnsignedValues() throws Exception {
        int sequence = 42;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("sequence", new UnsignedInteger(sequence));
        CoreMapMessageWrapper msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        Assertions.assertEquals((int)msg.getInt("sequence"), (int)sequence);
        map.clear();
        map.put("sequence", new UnsignedLong((long)sequence));
        msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        Assertions.assertEquals((long)msg.getLong("sequence"), (long)sequence);
        map.clear();
        map.put("sequence", new UnsignedShort((short)sequence));
        msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        Assertions.assertEquals((int)msg.getShort("sequence"), (int)sequence);
        map.clear();
        map.put("sequence", new UnsignedByte((byte)sequence));
        msg = AMQPMessageSupport.createMapMessage((long)1L, map, null);
        Assertions.assertEquals((int)msg.getByte("sequence"), (int)sequence);
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationByMessageIDUUID() throws Throwable {
        this.doTestReplyCorrelation(UUID.randomUUID(), false);
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationByMessageIDString() throws Throwable {
        this.doTestReplyCorrelation("mystring", false);
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationByMessageIDBinary() throws Throwable {
        this.doTestReplyCorrelation(BINARY_CORRELATION_ID, false);
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationByCorrelationIDUUID() throws Throwable {
        this.doTestReplyCorrelation(UUID.randomUUID(), true);
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationByCorrelationIDString() throws Throwable {
        this.doTestReplyCorrelation("mystring", true);
    }

    @Test
    @Timeout(value=60L)
    public void testCorrelationByCorrelationIDBinary() throws Throwable {
        this.doTestReplyCorrelation(BINARY_CORRELATION_ID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestReplyCorrelation(Object correlationId, boolean sendCorrelAsCorrelation) throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            String destinationAddress = this.getQueueName(1);
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender("activemq.management");
            AmqpReceiver receiver = session.createReceiver(destinationAddress);
            receiver.flow(10);
            AmqpMessage request = new AmqpMessage();
            request.setApplicationProperty("_AMQ_ResourceName", "broker");
            request.setApplicationProperty("_AMQ_OperationName", "getQueueNames");
            request.setReplyToAddress(destinationAddress);
            if (sendCorrelAsCorrelation) {
                request.setRawCorrelationId(correlationId);
            } else {
                request.setRawMessageId(correlationId);
            }
            request.setText("[]");
            sender.send(request);
            AmqpMessage response = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((Object)correlationId, (Object)response.getRawCorrelationId());
            response.accept();
        }
    }
}

