/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQCrashTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public ActiveMQServer server;
    private volatile boolean ackReceived;
    private ServerLocator locator;

    @Test
    public void testHang() throws Exception {
        Configuration configuration = this.createDefaultInVMConfig().setPersistenceEnabled(false);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration));
        this.server.start();
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new AckInterceptor(this.server));
        this.locator.setConfirmationWindowSize(1);
        ClientSessionFactory clientSessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = clientSessionFactory.createSession();
        session.setSendAcknowledgementHandler(message -> {
            this.ackReceived = true;
        });
        ClientProducer producer = session.createProducer("fooQueue");
        ClientMessage msg = session.createMessage(false);
        msg.putStringProperty("someKey", "someValue");
        producer.send((Message)msg);
        Thread.sleep(250L);
        Assertions.assertFalse((boolean)this.ackReceived);
        session.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
    }

    public static class AckInterceptor
    implements Interceptor {
        private final ActiveMQServer server;

        AckInterceptor(ActiveMQServer server) {
            this.server = server;
        }

        public boolean intercept(Packet packet, RemotingConnection connection) throws ActiveMQException {
            logger.debug("AckInterceptor.intercept {}", (Object)packet);
            if (packet.getType() == 71) {
                try {
                    logger.debug("Stopping server");
                    new Thread(() -> {
                        try {
                            this.server.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
            return true;
        }
    }
}

