/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoDeleteCreatedQueueTest
extends ActiveMQTestBase {
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    public final SimpleString queueConfigurationManaged = SimpleString.of((String)"queueConfigurationManaged");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(500L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(500L);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testAutoDeleteCreatedQueueOnLastConsumerClose() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteCreatedQueues(Boolean.valueOf(true)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(false)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        Assertions.assertTrue((boolean)this.server.locateQueue(this.queueA).isAutoDelete());
        this.cf.createSession().createConsumer(this.queueA).close();
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null);
    }

    @Test
    public void testAutoDeleteCreatedQueueDoesNOTDeleteConfigurationManagedQueuesOnLastConsumerClose() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteCreatedQueues(Boolean.valueOf(true)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.MULTICAST).setAutoCreated(Boolean.valueOf(false)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueConfigurationManaged).setAddress(this.addressA).setRoutingType(RoutingType.MULTICAST).setAutoCreated(Boolean.valueOf(false)).setConfigurationManaged(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueConfigurationManaged));
        Assertions.assertTrue((boolean)this.server.locateQueue(this.queueA).isAutoDelete());
        Assertions.assertFalse((boolean)this.server.locateQueue(this.queueConfigurationManaged).isAutoDelete());
        this.cf.createSession().createConsumer(this.queueA).close();
        this.cf.createSession().createConsumer(this.queueConfigurationManaged).close();
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null);
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueConfigurationManaged));
    }
}

