/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionClosedOnRemotingConnectionFailureTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSessionFactory sf;

    @Test
    public void testSessionClosedOnRemotingConnectionFailure() throws Exception {
        ClientSession session = this.addClientSession(this.sf.createSession());
        session.createQueue(QueueConfiguration.of((String)"fooqueue").setAddress("fooaddress").setRoutingType(RoutingType.ANYCAST));
        ClientProducer prod = session.createProducer("fooaddress");
        ClientConsumer cons = session.createConsumer("fooqueue");
        session.start();
        prod.send((Message)session.createMessage(false));
        Assertions.assertNotNull((Object)cons.receive());
        RemotingConnection connection = ((ClientSessionInternal)session).getConnection();
        connection.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        Assertions.assertTrue((boolean)session.isClosed());
        Assertions.assertTrue((boolean)prod.isClosed());
        Assertions.assertTrue((boolean)cons.isClosed());
        try {
            prod.send((Message)session.createMessage(false));
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQObjectClosedException activeMQObjectClosedException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        try {
            cons.receive();
            Assertions.fail((String)"Should throw exception");
        }
        catch (ActiveMQObjectClosedException e) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
        session.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.createServer(false, config);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(locator);
    }
}

