/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.jms2client;

import jakarta.jms.CompletionListener;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JmsProducerCompletionListenerTest
extends JMSTestBase {
    static final int TOTAL_MSGS = 200;
    private JMSContext context;
    private JMSProducer producer;
    private Queue queue;
    private final int confirmationWindowSize;

    @Parameters(name="confirmationWindowSize={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({-1}, {0}, {10}, {1000});
    }

    public JmsProducerCompletionListenerTest(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
    }

    @Override
    protected void testCaseCfExtraConfig(ConnectionFactoryConfiguration configuration) {
        configuration.setConfirmationWindowSize(this.confirmationWindowSize);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = this.createContext();
        this.producer = this.context.createProducer();
        this.queue = this.createQueue(this.name + "Queue");
    }

    @TestTemplate
    public void testCompletionListener() throws InterruptedException {
        CountingCompletionListener cl = new CountingCompletionListener(200);
        Assertions.assertNull((Object)this.producer.getAsync());
        this.producer.setAsync((CompletionListener)cl);
        Assertions.assertEquals((Object)cl, (Object)this.producer.getAsync());
        this.producer.setAsync(null);
        this.producer.setAsync((CompletionListener)cl);
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue);
        this.sendMessages(this.context, this.producer, this.queue, 200);
        this.receiveMessages(consumer, 0, 200, true);
        Assertions.assertEquals((int)200, (int)cl.completion.get());
        this.context.close();
        Assertions.assertTrue((boolean)cl.completionLatch.await(3L, TimeUnit.SECONDS), (String)"completion listener should be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testNullCompletionListener() throws Exception {
        try (Connection connection = null;){
            connection = this.cf.createConnection();
            Session session = connection.createSession();
            MessageProducer prod = session.createProducer((Destination)this.queue);
            prod.send(session.createMessage(), null);
            Assertions.fail((String)"Didn't get expected exception!");
        }
    }

    @TestTemplate
    public void testInvalidCallFromListener() throws InterruptedException {
        JMSConsumer consumer = this.context.createConsumer((Destination)this.queue);
        ArrayList<InvalidCompletionListener> listeners = new ArrayList<InvalidCompletionListener>();
        for (int i = 0; i < 3; ++i) {
            InvalidCompletionListener cl = new InvalidCompletionListener(this.context, i);
            listeners.add(cl);
            this.producer.setAsync((CompletionListener)cl);
            this.sendMessages(this.context, this.producer, this.queue, 1);
        }
        this.receiveMessages(consumer, 0, 1, true);
        this.context.close();
        for (InvalidCompletionListener cl : listeners) {
            Assertions.assertTrue((boolean)cl.latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertNotNull((Object)cl.error);
            Assertions.assertTrue((boolean)(cl.error instanceof IllegalStateRuntimeException));
        }
    }

    public static final class CountingCompletionListener
    implements CompletionListener {
        public AtomicInteger completion = new AtomicInteger(0);
        public int error;
        public CountDownLatch completionLatch;
        public Message lastMessage;

        public CountingCompletionListener(int n) {
            this.completionLatch = new CountDownLatch(n);
        }

        public void onCompletion(Message message) {
            this.completion.incrementAndGet();
            this.completionLatch.countDown();
            this.lastMessage = message;
        }

        public void onException(Message message, Exception exception) {
            ++this.error;
        }

        public String toString() {
            return JmsProducerCompletionListenerTest.class.getSimpleName() + ":" + CountingCompletionListener.class.getSimpleName() + ":" + this.completionLatch;
        }
    }

    public static final class InvalidCompletionListener
    implements CompletionListener {
        private final JMSContext context;
        public final CountDownLatch latch = new CountDownLatch(1);
        private Exception error;
        private final int call;

        public InvalidCompletionListener(JMSContext context, int call) {
            this.call = call;
            this.context = context;
        }

        public void onCompletion(Message message) {
            this.latch.countDown();
            try {
                switch (this.call) {
                    case 0: {
                        this.context.rollback();
                        break;
                    }
                    case 1: {
                        this.context.commit();
                        break;
                    }
                    case 2: {
                        this.context.close();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("call code " + this.call);
                    }
                }
            }
            catch (Exception error1) {
                this.error = error1;
            }
        }

        public void onException(Message message, Exception exception) {
            this.latch.countDown();
            try {
                switch (this.call) {
                    case 0: {
                        this.context.rollback();
                        break;
                    }
                    case 1: {
                        this.context.commit();
                        break;
                    }
                    case 2: {
                        this.context.close();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("call code " + this.call);
                    }
                }
            }
            catch (Exception error1) {
                this.error = error1;
            }
        }
    }
}

