/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.SequentialFileFactoryTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MappedSequentialFileFactoryTest
extends SequentialFileFactoryTestBase {
    @Override
    protected SequentialFileFactory createFactory(String folder) {
        return new MappedSequentialFileFactory(new File(folder), 2048, false, 0, 0, null);
    }

    @Test
    public void testInterrupts() throws Throwable {
        EncodingSupport fakeEncoding = new EncodingSupport(){

            public int getEncodeSize() {
                return 10;
            }

            public void encode(ActiveMQBuffer buffer) {
                buffer.writeBytes(new byte[10]);
            }

            public void decode(ActiveMQBuffer buffer) {
            }
        };
        AtomicInteger calls = new AtomicInteger(0);
        MappedSequentialFileFactory factory = new MappedSequentialFileFactory(new File(this.getTestDir()), fakeEncoding.getEncodeSize(), false, 0, 0, (code, message, file) -> {
            new Exception("shutdown").printStackTrace();
            calls.incrementAndGet();
        });
        Thread threadOpen = new Thread(() -> {
            try {
                Thread.currentThread().interrupt();
                SequentialFile file = factory.createSequentialFile("file.txt");
                file.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        threadOpen.start();
        threadOpen.join();
        Thread threadClose = new Thread(() -> {
            try {
                SequentialFile file = factory.createSequentialFile("file.txt");
                file.open();
                file.write(fakeEncoding, true);
                Thread.currentThread().interrupt();
                file.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        threadClose.start();
        threadClose.join();
        Thread threadWrite = new Thread(() -> {
            try {
                SequentialFile file = factory.createSequentialFile("file.txt");
                file.open();
                Thread.currentThread().interrupt();
                file.write(fakeEncoding, true);
                file.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        threadWrite.start();
        threadWrite.join();
        Thread threadFill = new Thread(() -> {
            try {
                SequentialFile file = factory.createSequentialFile("file.txt");
                file.open();
                Thread.currentThread().interrupt();
                file.fill(fakeEncoding.getEncodeSize());
                file.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        threadFill.start();
        threadFill.join();
        Thread threadWriteDirect = new Thread(() -> {
            try {
                SequentialFile file = factory.createSequentialFile("file.txt");
                file.open();
                ByteBuffer buffer = ByteBuffer.allocate(10);
                buffer.put(new byte[10]);
                Thread.currentThread().interrupt();
                file.writeDirect(buffer, true);
                file.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        threadWriteDirect.start();
        threadWriteDirect.join();
        Thread threadRead = new Thread(() -> {
            try {
                SequentialFile file = factory.createSequentialFile("file.txt");
                file.open();
                file.write(fakeEncoding, true);
                file.position(0L);
                ByteBuffer readBytes = ByteBuffer.allocate(fakeEncoding.getEncodeSize());
                Thread.currentThread().interrupt();
                file.read(readBytes);
                file.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        threadRead.start();
        threadRead.join();
        Assertions.assertEquals((int)0, (int)calls.get());
    }
}

