/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.lang.management.ManagementFactory;
import java.security.Principal;
import java.util.HashSet;
import javax.management.JMX;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SecurityNotificationTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession adminSession;
    private ClientConsumer notifConsumer;
    private SimpleString notifQueue;

    @Test
    public void testSECURITY_AUTHENTICATION_VIOLATION() throws Exception {
        String unknownUser = RandomUtil.randomString();
        SecurityNotificationTest.flush(this.notifConsumer);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        long start = System.currentTimeMillis();
        try {
            sf.createSession(unknownUser, RandomUtil.randomString(), false, true, true, false, 1);
            Assertions.fail((String)"authentication must fail and a notification of security violation must be sent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClientMessage[] notifications = SecurityNotificationTest.consumeMessages(1, this.notifConsumer);
        Assertions.assertEquals((Object)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertEquals((Object)unknownUser, (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER).toString());
        Assertions.assertEquals((Object)"unavailable", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_CERT_SUBJECT_DN).toString());
        Assertions.assertEquals((Object)"invm:0", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_REMOTE_ADDRESS).toString());
        Assertions.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assertions.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
    }

    @Test
    public void testSECURITY_PERMISSION_VIOLATION() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        Role role = new Role("roleCanNotCreateQueue", true, true, false, true, false, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch(address.toString(), roles);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addRole("guest", "roleCanNotCreateQueue");
        SecurityNotificationTest.flush(this.notifConsumer);
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession guestSession = sf.createSession("guest", "guest", false, true, true, false, 1);
        long start = System.currentTimeMillis();
        try {
            guestSession.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
            Assertions.fail((String)"session creation must fail and a notification of security violation must be sent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClientMessage[] notifications = SecurityNotificationTest.consumeMessages(2, this.notifConsumer);
        int i = 0;
        for (i = 0; i < notifications.length && !CoreNotificationType.SECURITY_PERMISSION_VIOLATION.toString().equals(notifications[i].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString()); ++i) {
        }
        Assertions.assertTrue((i < notifications.length ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)CoreNotificationType.SECURITY_PERMISSION_VIOLATION.toString(), (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertEquals((Object)"guest", (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_USER).toString());
        Assertions.assertEquals((Object)address.toString(), (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assertions.assertEquals((Object)CheckType.CREATE_DURABLE_QUEUE.toString(), (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_CHECK_TYPE).toString());
        Assertions.assertTrue((notifications[i].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assertions.assertTrue(((Long)notifications[i].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)notifications[i].getTimestamp(), (long)((Long)notifications[i].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        guestSession.close();
    }

    @Test
    public void testSubjectSECURITY_PERMISSION_VIOLATION() throws Exception {
        SecurityNotificationTest.flush(this.notifConsumer);
        Subject guestSubject = new Subject();
        guestSubject.getPrincipals().add((Principal)new UserPrincipal("guest"));
        AddressControl addressControl = JMX.newMBeanProxy(ManagementFactory.getPlatformMBeanServer(), ObjectNameBuilder.DEFAULT.getAddressObjectName(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()), AddressControl.class, false);
        Exception e = Subject.doAs(guestSubject, () -> {
            try {
                addressControl.sendMessage(null, 1, "hi", false, null, null);
                Assertions.fail((String)"need Send permission");
            }
            catch (Exception expected) {
                Assertions.assertTrue((boolean)expected.getMessage().contains("guest"));
                Assertions.assertTrue((boolean)expected.getMessage().contains("SEND"));
                return expected;
            }
            return null;
        });
        Assertions.assertNotNull((Object)e, (String)"expect exception");
        ClientMessage[] notifications = SecurityNotificationTest.consumeMessages(3, this.notifConsumer);
        int i = 0;
        for (i = 0; i < notifications.length && !CoreNotificationType.SECURITY_PERMISSION_VIOLATION.toString().equals(notifications[i].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString()); ++i) {
        }
        Assertions.assertTrue((i < notifications.length ? (byte)1 : 0) != 0);
        Assertions.assertEquals((Object)CoreNotificationType.SECURITY_PERMISSION_VIOLATION.toString(), (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertEquals((Object)"guest", (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_USER).toString());
        Assertions.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString(), (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assertions.assertEquals((Object)CheckType.SEND.toString(), (Object)notifications[i].getObjectProperty(ManagementHelper.HDR_CHECK_TYPE).toString());
    }

    @Test
    public void testCONSUMER_CREATED() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        Role role = new Role("role", true, true, true, true, false, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch(address.toString(), roles);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addRole("guest", "role");
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession guestSession = sf.createSession("guest", "guest", false, true, true, false, 1);
        guestSession.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        SecurityNotificationTest.flush(this.notifConsumer);
        long start = System.currentTimeMillis();
        guestSession.createConsumer(queue);
        ClientMessage[] notifications = SecurityNotificationTest.consumeMessages(1, this.notifConsumer);
        Assertions.assertEquals((Object)CoreNotificationType.CONSUMER_CREATED.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TYPE).toString());
        Assertions.assertEquals((Object)"guest", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_USER).toString());
        Assertions.assertEquals((Object)"guest", (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_VALIDATED_USER).toString());
        Assertions.assertEquals((Object)address.toString(), (Object)notifications[0].getObjectProperty(ManagementHelper.HDR_ADDRESS).toString());
        Assertions.assertEquals((Object)SimpleString.of((String)"unavailable"), (Object)notifications[0].getSimpleStringProperty(ManagementHelper.HDR_CERT_SUBJECT_DN));
        Assertions.assertTrue((notifications[0].getTimestamp() >= start ? (byte)1 : 0) != 0);
        Assertions.assertTrue(((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP) >= start ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)notifications[0].getTimestamp(), (long)((Long)notifications[0].getObjectProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP)));
        guestSession.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig().setSecurityEnabled(true).setJMXManagementEnabled(true);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        this.server.start();
        this.notifQueue = RandomUtil.randomSimpleString();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("admin", "admin");
        securityManager.getConfiguration().addUser("guest", "guest");
        securityManager.getConfiguration().setDefaultUser("guest");
        Role role = new Role("notif", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        this.server.getSecurityRepository().addMatch(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress().toString(), roles);
        securityManager.getConfiguration().addRole("admin", "notif");
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        this.adminSession = sf.createSession("admin", "admin", false, true, true, false, 1);
        this.adminSession.start();
        this.adminSession.createQueue(QueueConfiguration.of((SimpleString)this.notifQueue).setAddress(ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress()).setDurable(Boolean.valueOf(false)).setTemporary(Boolean.valueOf(true)));
        this.notifConsumer = this.adminSession.createConsumer(this.notifQueue);
    }

    private static void flush(ClientConsumer notifConsumer) throws ActiveMQException {
        ClientMessage message = null;
        while ((message = notifConsumer.receive(500L)) != null) {
        }
    }

    protected static ClientMessage[] consumeMessages(int expected, ClientConsumer consumer) throws Exception {
        ClientMessage[] messages = new ClientMessage[expected];
        ClientMessage m = null;
        for (int i = 0; i < expected; ++i) {
            m = consumer.receive(500L);
            Assertions.assertNotNull((Object)m, (String)("expected to received " + expected + " messages, got only " + i));
            messages[i] = m;
            m.acknowledge();
        }
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m, (String)("received one more message than expected (" + expected + ")"));
        return messages;
    }
}

