/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MqttClusterRemoteSubscribeLoadBalanceOffTest
extends ClusterTestBase {
    @Override
    protected boolean isResolveProtocols() {
        return true;
    }

    public boolean isNetty() {
        return true;
    }

    @Test
    public void testPub0Sub1() throws Exception {
        String TOPIC = "test/1";
        String clientId1 = "clientId1";
        String clientId2 = "clientId2";
        Topic[] topics = new Topic[]{new Topic("test/1", QoS.AT_MOST_ONCE)};
        this.setupServers("test/1");
        this.startServers(0, 1);
        BlockingConnection connection1 = MqttClusterRemoteSubscribeLoadBalanceOffTest.retrieveMQTTConnection("tcp://localhost:61616", "clientId1");
        BlockingConnection connection2 = MqttClusterRemoteSubscribeLoadBalanceOffTest.retrieveMQTTConnection("tcp://localhost:61617", "clientId2");
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection1.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
        Assertions.assertTrue((boolean)Wait.waitFor(() -> connection2.isConnected(), (long)5000L, (long)100L), (String)"Should be connected");
        this.waitForTopology(this.servers[0], "cluster0", 2, 5000L);
        this.waitForTopology(this.servers[1], "cluster1", 2, 5000L);
        connection1.subscribe(topics);
        connection2.subscribe(topics);
        this.waitForBindings(0, "test/1", 1, 1, false);
        this.waitForBindings(1, "test/1", 1, 1, false);
        String payload1 = "This is message 1";
        String payload2 = "This is message 2";
        connection1.publish("test/1", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection2.publish("test/1", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
        Message message1 = connection1.receive(5L, TimeUnit.SECONDS);
        message1.ack();
        Message message2 = connection1.receive(5L, TimeUnit.SECONDS);
        message2.ack();
        message1 = connection2.receive(5L, TimeUnit.SECONDS);
        message1.ack();
        message2 = connection2.receive(5L, TimeUnit.SECONDS);
        message2.ack();
        String[] topicsStrings = new String[]{"test/1"};
        if (connection1 != null && connection1.isConnected()) {
            connection1.unsubscribe(topicsStrings);
            connection1.disconnect();
        }
        if (connection2 != null && connection2.isConnected()) {
            connection2.unsubscribe(topicsStrings);
            connection2.disconnect();
        }
    }

    private static BlockingConnection retrieveMQTTConnection(String host, String clientId) throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setHost(host);
        mqtt.setClientId(clientId);
        mqtt.setConnectAttemptsMax(0L);
        mqtt.setReconnectAttemptsMax(0L);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        return connection;
    }

    private void setupServers(String address) throws Exception {
        WildcardConfiguration wildcardConfiguration = this.createWildCardConfiguration();
        CoreAddressConfiguration coreAddressConfiguration = this.createAddressConfiguration(address);
        AddressSettings addressSettings = this.createAddressSettings();
        this.setupServer(0, false, this.isNetty());
        this.servers[0].getConfiguration().addAddressConfiguration(coreAddressConfiguration);
        this.servers[0].getConfiguration().addAddressSetting("#", addressSettings);
        this.servers[0].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
        this.setupServer(1, false, this.isNetty());
        this.servers[1].getConfiguration().addAddressConfiguration(coreAddressConfiguration);
        this.servers[1].getConfiguration().addAddressSetting("#", addressSettings);
        this.servers[1].getConfiguration().setWildCardConfiguration(wildcardConfiguration);
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.OFF, 1, this.isNetty(), 1, 0);
    }

    private AddressSettings createAddressSettings() {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setRedistributionDelay(0L);
        addressSettings.setDefaultAddressRoutingType(RoutingType.MULTICAST);
        return addressSettings;
    }

    private CoreAddressConfiguration createAddressConfiguration(String TOPIC) {
        CoreAddressConfiguration coreAddressConfiguration = new CoreAddressConfiguration();
        coreAddressConfiguration.addRoutingType(RoutingType.MULTICAST);
        coreAddressConfiguration.setName(TOPIC);
        return coreAddressConfiguration;
    }

    private WildcardConfiguration createWildCardConfiguration() {
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setAnyWords('#');
        wildcardConfiguration.setDelimiter('/');
        wildcardConfiguration.setRoutingEnabled(true);
        wildcardConfiguration.setSingleWord('+');
        return wildcardConfiguration;
    }
}

