/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.jms.persistence.JMSStorageManager;
import org.apache.activemq.artemis.jms.persistence.config.PersistedBindings;
import org.apache.activemq.artemis.jms.persistence.config.PersistedConnectionFactory;
import org.apache.activemq.artemis.jms.persistence.config.PersistedDestination;
import org.apache.activemq.artemis.jms.persistence.config.PersistedType;
import org.apache.activemq.artemis.jms.persistence.impl.journal.JMSJournalStorageManagerImpl;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.TimeAndCounterIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JMSStorageManagerTest
extends ActiveMQTestBase {
    private Map<String, PersistedConnectionFactory> mapExpectedCFs;
    protected JMSStorageManager jmsJournal;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mapExpectedCFs = new HashMap<String, PersistedConnectionFactory>();
    }

    protected void addSetting(PersistedConnectionFactory setting) throws Exception {
        this.mapExpectedCFs.put(setting.getName(), setting);
        this.jmsJournal.storeConnectionFactory(setting);
    }

    @Test
    public void testSettings() throws Exception {
        this.createJMSStorage();
        ArrayList<CallSite> transportConfigs = new ArrayList<CallSite>();
        for (int i = 0; i < 5; ++i) {
            transportConfigs.add((CallSite)((Object)("c1-" + i)));
            transportConfigs.add((CallSite)((Object)("c2-" + i)));
        }
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("some-name").setConnectorNames(transportConfigs);
        this.addSetting(new PersistedConnectionFactory(config));
        this.jmsJournal.stop();
        this.createJMSStorage();
        List cfs = this.jmsJournal.recoverConnectionFactories();
        Assertions.assertEquals((int)1, (int)cfs.size());
        Assertions.assertEquals((Object)"some-name", (Object)((PersistedConnectionFactory)cfs.get(0)).getName());
        PersistedConnectionFactory cf1 = (PersistedConnectionFactory)cfs.get(0);
        Assertions.assertEquals((int)10, (int)cf1.getConfig().getConnectorNames().size());
        List configs = cf1.getConfig().getConnectorNames();
        int i = 0;
        int j = 0;
        while (i < 10) {
            Assertions.assertEquals(configs.get(i), (Object)("c1-" + j));
            Assertions.assertEquals(configs.get(i + 1), (Object)("c2-" + j));
            i += 2;
            ++j;
        }
    }

    @Test
    public void testSizeOfCF() throws Exception {
        String[] str = new String[5];
        for (int i = 0; i < 5; ++i) {
            str[i] = "str" + i;
        }
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("some-name").setConnectorNames(new ArrayList()).setBindings(new String[]{""});
        int size = config.getEncodeSize();
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)size);
        config.encode(buffer);
        Assertions.assertEquals((int)size, (int)buffer.writerIndex());
        PersistedConnectionFactory persistedCF = new PersistedConnectionFactory(config);
        size = persistedCF.getEncodeSize();
        buffer = ActiveMQBuffers.fixedBuffer((int)size);
        persistedCF.encode(buffer);
        Assertions.assertEquals((int)size, (int)buffer.writerIndex());
    }

    @Test
    public void testSettingsWithConnectorConfigs() throws Exception {
        this.createJMSStorage();
        String[] str = new String[5];
        for (int i = 0; i < 5; ++i) {
            str[i] = "str" + i;
        }
        ArrayList connectorConfigs = new ArrayList();
        HashMap<String, Integer> primaryParams = new HashMap<String, Integer>();
        primaryParams.put("port", 5665);
        HashMap<String, Integer> backupParams = new HashMap<String, Integer>();
        backupParams.put("port", 5775);
        HashMap<String, Integer> primaryParams2 = new HashMap<String, Integer>();
        primaryParams2.put("port", 6665);
        ConnectionFactoryConfiguration config = new ConnectionFactoryConfigurationImpl().setName("some-name").setConnectorNames(connectorConfigs).setBindings(str).setCallTimeout(RandomUtil.randomPositiveLong());
        ArrayList<Pair> connectors = new ArrayList<Pair>();
        connectors.add(new Pair((Object)RandomUtil.randomString(), null));
        this.addSetting(new PersistedConnectionFactory(config));
        this.jmsJournal.stop();
        this.createJMSStorage();
        List cfs = this.jmsJournal.recoverConnectionFactories();
        Assertions.assertEquals((int)1, (int)cfs.size());
        Assertions.assertEquals((Object)"some-name", (Object)((PersistedConnectionFactory)cfs.get(0)).getName());
        Assertions.assertEquals((long)config.getCallTimeout(), (long)((PersistedConnectionFactory)cfs.get(0)).getConfig().getCallTimeout());
    }

    @Test
    public void testJNDIPersistence() throws Exception {
        this.createJMSStorage();
        this.jmsJournal.storeDestination(new PersistedDestination(PersistedType.Queue, "jndiPersistQueue", null, true));
        this.jmsJournal.addBindings(PersistedType.Queue, "jndiPersistQueue", new String[]{"jndi-1"});
        List destinations = this.jmsJournal.recoverDestinations();
        List jndiList = this.jmsJournal.recoverPersistedBindings();
        Assertions.assertEquals((int)1, (int)destinations.size());
        Assertions.assertEquals((int)1, (int)jndiList.size());
        this.jmsJournal.deleteDestination(PersistedType.Queue, "jndiPersistQueue");
        destinations = this.jmsJournal.recoverDestinations();
        Assertions.assertEquals((int)0, (int)destinations.size());
        this.jmsJournal.stop();
        this.createJMSStorage();
        destinations = this.jmsJournal.recoverDestinations();
        Assertions.assertEquals((int)0, (int)destinations.size());
        jndiList = this.jmsJournal.recoverPersistedBindings();
        Assertions.assertEquals((int)1, (int)jndiList.size());
        PersistedBindings jndi = (PersistedBindings)jndiList.get(0);
        List jndis = jndi.getBindings();
        Assertions.assertEquals((int)1, (int)jndis.size());
        Assertions.assertEquals((Object)"jndi-1", jndis.get(0));
    }

    protected void createJMSStorage() throws Exception {
        this.jmsJournal = new JMSJournalStorageManagerImpl(null, (IDGenerator)new TimeAndCounterIDGenerator(), this.createDefaultInVMConfig(), null);
        this.runAfter(() -> ((JMSStorageManager)this.jmsJournal).stop());
        this.jmsJournal.start();
        this.jmsJournal.load();
    }
}

