/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExpiryRunnerTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private final SimpleString qName = SimpleString.of((String)"ExpiryRunnerTestQ");
    private final SimpleString qName2 = SimpleString.of((String)"ExpiryRunnerTestQ2");
    private SimpleString expiryQueue;
    private SimpleString expiryAddress;
    Queue artemisExpiryQueue;
    private ServerLocator locator;

    @Test
    public void testBasicExpire() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.qName);
        int numMessages = 100;
        long expiration = System.currentTimeMillis();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + i);
            m.setExpiration(expiration);
            producer.send((Message)m);
        }
        Thread.sleep(1600L);
        Assertions.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getMessageCount());
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getDeliveringCount());
    }

    @Test
    public void testExpireFromMultipleQueues() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.qName);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName2).setDurable(Boolean.valueOf(false)));
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(this.expiryAddress);
        this.server.getAddressSettingsRepository().addMatch(this.qName2.toString(), (Object)addressSettings);
        ClientProducer producer2 = this.clientSession.createProducer(this.qName2);
        int numMessages = 100;
        long expiration = System.currentTimeMillis();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + i);
            m.setExpiration(expiration);
            producer.send((Message)m);
            m = this.createTextMessage(this.clientSession, "m" + i);
            m.setExpiration(expiration);
            producer2.send((Message)m);
        }
        Thread.sleep(1600L);
        Assertions.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getMessageCount());
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getDeliveringCount());
    }

    @Test
    public void testExpireHalf() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.qName);
        int numMessages = 100;
        long expiration = System.currentTimeMillis();
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + i);
            if (i % 2 == 0) {
                m.setExpiration(expiration);
            }
            producer.send((Message)m);
        }
        Thread.sleep(1600L);
        Assertions.assertEquals((long)(numMessages / 2), (long)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getMessageCount());
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getDeliveringCount());
    }

    @Test
    public void testExpireConsumeHalf() throws Exception {
        ClientProducer producer = this.clientSession.createProducer(this.qName);
        int numMessages = 100;
        long expiration = System.currentTimeMillis() + 1000L;
        for (int i = 0; i < numMessages; ++i) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + i);
            m.setExpiration(expiration);
            producer.send((Message)m);
        }
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        this.clientSession.start();
        for (int i = 0; i < numMessages / 2; ++i) {
            ClientMessage cm = consumer.receive(500L);
            Assertions.assertNotNull((Object)cm, (String)("message not received " + i));
            cm.acknowledge();
            Assertions.assertEquals((Object)("m" + i), (Object)cm.getBodyBuffer().readString());
        }
        consumer.close();
        Wait.assertEquals((long)0L, () -> ((Queue)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable())).getMessageCount());
        Wait.assertEquals((int)0, () -> ((Queue)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable())).getDeliveringCount());
        Wait.assertEquals((long)(numMessages / 2), () -> ((Queue)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable())).getMessagesExpired());
    }

    @Test
    public void testExpireToExpiryQueue() throws Exception {
        ClientMessage cm;
        int i;
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(this.expiryAddress);
        this.server.getAddressSettingsRepository().addMatch(this.qName2.toString(), (Object)addressSettings);
        this.clientSession.deleteQueue(this.qName);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName2).setAddress(this.qName).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(this.qName);
        int numMessages = 100;
        long expiration = System.currentTimeMillis();
        for (int i2 = 0; i2 < numMessages; ++i2) {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + i2);
            m.setExpiration(expiration);
            producer.send((Message)m);
        }
        Thread.sleep(1600L);
        Assertions.assertEquals((long)0L, (long)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getMessageCount());
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getDeliveringCount());
        ClientConsumer consumer = this.clientSession.createConsumer(this.expiryQueue);
        this.clientSession.start();
        for (i = 0; i < numMessages; ++i) {
            cm = consumer.receive(500L);
            Assertions.assertNotNull((Object)cm);
        }
        for (i = 0; i < numMessages; ++i) {
            cm = consumer.receive(500L);
            Assertions.assertNotNull((Object)cm);
        }
        Assertions.assertEquals((long)100L, (long)((Queue)this.server.getPostOffice().getBinding(this.qName).getBindable()).getMessagesExpired());
        consumer.close();
    }

    @Test
    public void testExpireWhilstConsumingMessagesStillInOrder() throws Exception {
        ClientMessage cm;
        ClientProducer producer = this.clientSession.createProducer(this.qName);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName);
        CountDownLatch latch = new CountDownLatch(1);
        DummyMessageHandler dummyMessageHandler = new DummyMessageHandler(consumer, latch);
        this.clientSession.start();
        Thread thr = new Thread(dummyMessageHandler);
        thr.start();
        long expiration = System.currentTimeMillis() + 1000L;
        int numMessages = 0;
        long sendMessagesUntil = System.currentTimeMillis() + 2000L;
        do {
            ClientMessage m = this.createTextMessage(this.clientSession, "m" + numMessages++);
            m.setExpiration(expiration);
            producer.send((Message)m);
            Thread.sleep(100L);
        } while (System.currentTimeMillis() < sendMessagesUntil);
        Assertions.assertTrue((boolean)latch.await(10000L, TimeUnit.MILLISECONDS));
        consumer.close();
        consumer = this.clientSession.createConsumer(this.expiryQueue);
        while ((cm = consumer.receive(2000L)) != null) {
            String text = cm.getBodyBuffer().readString();
            cm.acknowledge();
            Assertions.assertFalse((boolean)dummyMessageHandler.payloads.contains(text));
            dummyMessageHandler.payloads.add(text);
        }
        for (int i = 0; i < numMessages && !dummyMessageHandler.payloads.isEmpty(); ++i) {
            Assertions.assertTrue((boolean)dummyMessageHandler.payloads.remove("m" + i), (String)("m" + i));
        }
        consumer.close();
        thr.join();
    }

    @Test
    public void testManyQueuesExpire() throws Exception {
        final AtomicInteger currentExpiryHappening = new AtomicInteger();
        final AtomicInteger maxExpiryHappening = new AtomicInteger(0);
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerQueuePlugin(){

            public void beforeExpiryScan(Queue queue) {
                currentExpiryHappening.incrementAndGet();
                while (!maxExpiryHappening.compareAndSet(maxExpiryHappening.get(), Math.max(maxExpiryHappening.get(), currentExpiryHappening.get()))) {
                    Thread.yield();
                }
            }

            public void afterExpiryScan(Queue queue) {
                currentExpiryHappening.decrementAndGet();
            }
        });
        Assertions.assertTrue((boolean)this.server.hasBrokerQueuePlugins());
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setExpiryAddress(this.expiryAddress));
        for (int ad = 0; ad < 1000; ++ad) {
            this.server.addAddressInfo(new AddressInfo("test" + ad));
            this.server.createQueue(QueueConfiguration.of((String)("test" + ad)).setAddress("test" + ad).setRoutingType(RoutingType.ANYCAST));
        }
        ClientProducer producer = this.clientSession.createProducer();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = this.clientSession.createMessage(true);
            message.setExpiration(System.currentTimeMillis());
            producer.send("test" + i, (Message)message);
        }
        Wait.assertEquals((long)1000L, () -> ((Queue)this.artemisExpiryQueue).getMessageCount());
        Assertions.assertTrue((maxExpiryHappening.get() == 1 ? (byte)1 : 0) != 0, (String)("The System had " + maxExpiryHappening + " threads in parallel scanning for expiration"));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ConfigurationImpl configuration = (ConfigurationImpl)this.createDefaultInVMConfig().setMessageExpiryScanPeriod(100L);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = sessionFactory.createSession(false, true, true);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName).setDurable(Boolean.valueOf(false)));
        this.expiryAddress = SimpleString.of((String)"EA");
        this.expiryQueue = SimpleString.of((String)"expiryQ");
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(this.expiryAddress);
        this.server.getAddressSettingsRepository().addMatch(this.qName.toString(), (Object)addressSettings);
        this.server.getAddressSettingsRepository().addMatch(this.qName2.toString(), (Object)addressSettings);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.expiryQueue).setAddress(this.expiryAddress).setDurable(Boolean.valueOf(true)));
        this.artemisExpiryQueue = this.server.locateQueue(this.expiryQueue);
        Assertions.assertNotNull((Object)this.artemisExpiryQueue);
    }

    private static class DummyMessageHandler
    implements Runnable {
        List<String> payloads = new ArrayList<String>();
        private final ClientConsumer consumer;
        private final CountDownLatch latch;

        private DummyMessageHandler(ClientConsumer consumer, CountDownLatch latch) {
            this.consumer = consumer;
            this.latch = latch;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    ClientMessage message;
                    while ((message = this.consumer.receive(5000L)) != null) {
                        message.acknowledge();
                        this.payloads.add(message.getBodyBuffer().readString());
                        Thread.sleep(110L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            this.latch.countDown();
        }
    }
}

