/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageExpirationTest
extends ActiveMQTestBase {
    private static final int EXPIRATION = 1000;
    private static final int MIN_EXPIRATION = 500;
    private static final int MAX_EXPIRATION = 1500;
    private ActiveMQServer server;
    private ClientSession session;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testMessagesExpiredNoBindings() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString expiryAddress = RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setExpiryAddress(expiryAddress);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        Assertions.assertEquals((long)0L, (long)this.server.locateQueue(queue).getMessagesExpired());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(true);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((Message)message);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue).getMessagesExpired() == 1L, (long)2000L, (long)100L));
        Assertions.assertEquals((long)0L, (long)this.server.locateQueue(queue).getMessageCount());
        Assertions.assertEquals((int)0, (int)this.server.locateQueue(queue).getDeliveringCount());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessagesExpiredNoExpiryAddress() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        Assertions.assertEquals((long)0L, (long)this.server.locateQueue(queue).getMessagesExpired());
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(true);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((Message)message);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(queue).getMessagesExpired() == 1L, (long)2000L, (long)100L));
        Assertions.assertEquals((long)0L, (long)this.server.locateQueue(queue).getMessageCount());
        Assertions.assertEquals((int)0, (int)this.server.locateQueue(queue).getDeliveringCount());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageWithNoExpirationMinExpiryDelayOverride() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, true, false));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        AddressSettings addressSettings = new AddressSettings().setMinExpiryDelay(Long.valueOf(500L));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        producer.send((Message)message);
        long start = System.currentTimeMillis();
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(queue)).getMessagesExpired(), (long)5000L);
        Assertions.assertTrue((System.currentTimeMillis() - start > 500L ? (byte)1 : 0) != 0);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageWithTooSmallExpirationMinExpiryDelayOverride() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, true, false));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        AddressSettings addressSettings = new AddressSettings().setMinExpiryDelay(Long.valueOf(500L));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        message.setExpiration(System.currentTimeMillis() + 250L);
        producer.send((Message)message);
        long start = System.currentTimeMillis();
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(queue)).getMessagesExpired(), (long)5000L);
        Assertions.assertTrue((System.currentTimeMillis() - start > 500L ? (byte)1 : 0) != 0);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageWithNoExpirationMaxExpiryDelayOverride() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, true, false));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        AddressSettings addressSettings = new AddressSettings().setMaxExpiryDelay(Long.valueOf(1500L));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        producer.send((Message)message);
        long start = System.currentTimeMillis();
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(queue)).getMessagesExpired(), (long)5000L);
        Assertions.assertTrue((System.currentTimeMillis() - start <= 1700L ? (byte)1 : 0) != 0);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageWithTooLargeExpirationMaxExpiryDelayOverride() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, true, false));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        AddressSettings addressSettings = new AddressSettings().setMaxExpiryDelay(Long.valueOf(1500L));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        message.setExpiration(System.currentTimeMillis() + 3600000L);
        producer.send((Message)message);
        Queue serverQueue = this.server.locateQueue(queue);
        Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessagesExpired(), (long)5000L);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testMessageWithAcceptableExpirationMinMaxExpiryDelayOverride() throws Exception {
        SimpleString address = RandomUtil.randomSimpleString();
        SimpleString queue = RandomUtil.randomSimpleString();
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, true, false));
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.session.createProducer(address);
        ClientMessage message = this.session.createMessage(false);
        AddressSettings addressSettings = new AddressSettings().setMinExpiryDelay(Long.valueOf(500L)).setMaxExpiryDelay(Long.valueOf(1500L));
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        message.setExpiration(System.currentTimeMillis() + 1000L);
        producer.send((Message)message);
        long start = System.currentTimeMillis();
        Queue serverQueue = this.server.locateQueue(queue);
        Wait.assertEquals((long)1L, () -> ((Queue)serverQueue).getMessagesExpired(), (long)5000L);
        Assertions.assertTrue((System.currentTimeMillis() - start > 500L ? (byte)1 : 0) != 0);
        Assertions.assertTrue((System.currentTimeMillis() - start < 1500L ? (byte)1 : 0) != 0);
        this.session.deleteQueue(queue);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.getConfiguration().setMessageExpiryScanPeriod(100L);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }
}

