/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.message.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessagePropertyTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator locator;
    private ClientSessionFactory sf;
    private final int numMessages = 20;
    private static final String ADDRESS = "anAddress123";
    private static final SimpleString SIMPLE_STRING_KEY = SimpleString.of((String)"StringToSimpleString");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
    }

    private void sendMessages() throws Exception {
        ClientSession session = this.sf.createSession(true, true);
        String filter = null;
        session.createAddress(SimpleString.of((String)ADDRESS), RoutingType.MULTICAST, false);
        session.createQueue(QueueConfiguration.of((String)ADDRESS).setRoutingType(RoutingType.MULTICAST).setFilterString(filter));
        ClientProducer producer = session.createProducer(ADDRESS);
        for (int i = 0; i < 20; ++i) {
            ClientMessage message = session.createMessage(true);
            this.setBody(i, message);
            message.putIntProperty("int", i);
            message.putShortProperty("short", (short)i);
            message.putByteProperty("byte", (byte)i);
            message.putFloatProperty("float", this.floatValue(i));
            message.putStringProperty(SIMPLE_STRING_KEY, SimpleString.of((String)Integer.toString(i)));
            message.putBytesProperty("byte[]", this.byteArray(i));
            message.putObjectProperty("null-value", null);
            producer.send((Message)message);
        }
        session.commit();
    }

    private float floatValue(int i) {
        return (float)((double)i * 1.3);
    }

    private byte[] byteArray(int i) {
        return new byte[]{(byte)i, (byte)(i / 2)};
    }

    @Test
    public void testProperties() throws Exception {
        this.sendMessages();
        this.receiveMessages();
    }

    private void receiveMessages() throws Exception {
        ClientSession session = this.sf.createSession(true, true);
        session.start();
        try (ClientConsumer consumer = session.createConsumer(ADDRESS);){
            for (int i = 0; i < 20; ++i) {
                ClientMessage message = consumer.receive(100L);
                Assertions.assertNotNull((Object)message, (String)("Expecting a message " + i));
                this.assertMessageBody(i, message);
                Assertions.assertEquals((int)i, (int)message.getIntProperty("int"));
                Assertions.assertEquals((short)((short)i), (short)message.getShortProperty("short"));
                Assertions.assertEquals((byte)((byte)i), (byte)message.getByteProperty("byte"));
                Assertions.assertEquals((double)this.floatValue(i), (double)message.getFloatProperty("float").floatValue(), (double)0.001);
                Assertions.assertEquals((Object)SimpleString.of((String)Integer.toString(i)), (Object)message.getSimpleStringProperty(SIMPLE_STRING_KEY.toString()));
                MessagePropertyTest.assertEqualsByteArrays(this.byteArray(i), message.getBytesProperty("byte[]"));
                Assertions.assertNull((Object)message.getIngressTimestamp());
                Assertions.assertTrue((boolean)message.containsProperty("null-value"));
                Assertions.assertEquals((Object)message.getObjectProperty("null-value"), null);
                message.acknowledge();
            }
            Assertions.assertNull((Object)consumer.receive(50L), (String)"no more messages");
        }
        session.commit();
    }
}

