/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.ssl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.core.remoting.impl.ssl.SSLSupport;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SSLSupportTest
extends ActiveMQTestBase {
    private String storeProvider;
    private String storeType;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;

    @Parameters(name="storeProvider={0}, storeType={1}")
    public static Collection getParameters() {
        if (System.getProperty("java.vendor").contains("IBM")) {
            return Arrays.asList({TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS"}, {"IBMJCE", "JCEKS"});
        }
        return Arrays.asList({TransportConstants.DEFAULT_KEYSTORE_PROVIDER, "JKS"}, {"SunJCE", "JCEKS"}, {"SUN", "JKS"}, {"SunJSSE", "PKCS12"});
    }

    public SSLSupportTest(String storeProvider, String storeType) {
        this.storeProvider = storeProvider;
        this.storeType = storeType;
        String suffix = storeType.toLowerCase();
        if (storeType.equals("PKCS12")) {
            suffix = "p12";
        }
        this.keyStorePath = "server-keystore." + suffix;
        this.trustStorePath = "client-ca-truststore." + suffix;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.trustStorePassword = this.keyStorePassword = "securepass";
    }

    @TestTemplate
    public void testContextWithRightParameters() throws Exception {
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @TestTemplate
    public void testContextWithNullParameters() throws Exception {
        new SSLSupport().createContext();
    }

    @TestTemplate
    public void testContextWithKeyStorePathAsURL() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.keyStorePath);
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(url.toString()).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @TestTemplate
    public void testContextWithKeyStorePathAsFile() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(this.keyStorePath);
        File file = new File(url.toURI());
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(file.getAbsolutePath()).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @TestTemplate
    public void testContextWithBadKeyStorePath() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath("not a keystore").setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testContextWithNullKeyStorePath() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(null).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @TestTemplate
    public void testContextWithKeyStorePathAsRelativePath() throws Exception {
        File currentDir = new File(System.getProperty("user.dir"));
        if (!currentDir.getAbsolutePath().endsWith("tests")) {
            return;
        }
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath("../security-resources/" + this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
    }

    @TestTemplate
    public void testContextWithBadKeyStorePassword() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword("bad password").setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testContextWithNullKeyStorePassword() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(null).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword(this.trustStorePassword).createContext();
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertFalse((boolean)(e instanceof NullPointerException));
        }
    }

    @TestTemplate
    public void testContextWithBadTrustStorePath() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath("not a trust store").setTruststorePassword(this.trustStorePassword).createContext();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testContextWithBadTrustStorePassword() throws Exception {
        try {
            new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword("bad passord").createContext();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @TestTemplate
    public void testContextWithTrustAll() throws Exception {
        new SSLSupport().setKeystoreProvider(this.storeProvider).setKeystoreType(this.storeType).setKeystorePath(this.keyStorePath).setKeystorePassword(this.keyStorePassword).setTruststoreProvider(this.storeProvider).setTruststoreType(this.storeType).setTruststorePath(this.trustStorePath).setTruststorePassword("bad passord").setTrustAll(true).createContext();
    }
}

