/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.cluster.impl;

import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionBridge;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterConnectionBridgeTest
extends ActiveMQTestBase {
    @Test
    public void testCreateSelectorFromAddressForNormalMatches() {
        String address = "jms.my.address";
        String expectedSelector = ManagementHelper.HDR_ADDRESS + " LIKE '" + address + "%'";
        Assertions.assertEquals((Object)expectedSelector, (Object)ClusterConnectionBridge.createSelectorFromAddress((String)address));
    }

    @Test
    public void testCreateSelectorFromAddressForExclusions() {
        String address = "jms.my.address";
        String expectedSelector = ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address + "%'";
        Assertions.assertEquals((Object)expectedSelector, (Object)ClusterConnectionBridge.createSelectorFromAddress((String)("!" + address)));
    }

    @Test
    public void testCreateSelectorFromListForNormalMatches() {
        String address1 = "jms.test1.address";
        String address2 = "jms.test2.address";
        String addresses = address1 + "," + address2;
        StringBuilder expectedSelector = new StringBuilder();
        expectedSelector.append("(");
        expectedSelector.append("(" + ManagementHelper.HDR_ADDRESS + " LIKE '" + address1 + "%')");
        expectedSelector.append(" OR ");
        expectedSelector.append("(" + ManagementHelper.HDR_ADDRESS + " LIKE '" + address2 + "%')");
        expectedSelector.append(")");
        Assertions.assertEquals((Object)expectedSelector.toString(), (Object)ClusterConnectionBridge.createSelectorFromAddress((String)addresses));
    }

    @Test
    public void testCreateSelectorFromListForExclusions() {
        String address1 = "jms.test1.address";
        String address2 = "jms.test2.address";
        String addresses = "!" + address1 + ",!" + address2;
        StringBuilder expectedSelector = new StringBuilder();
        expectedSelector.append("(");
        expectedSelector.append("(" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address1 + "%')");
        expectedSelector.append(" AND ");
        expectedSelector.append("(" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address2 + "%')");
        expectedSelector.append(")");
        Assertions.assertEquals((Object)expectedSelector.toString(), (Object)ClusterConnectionBridge.createSelectorFromAddress((String)addresses));
    }

    @Test
    public void testCreateSelectorFromListForExclusionsAndNormalMatches() {
        String address1 = "jms.test1.address";
        String address2 = "jms.test2.address";
        String address3 = "jms.test3.address";
        String address4 = "jms.test4.address";
        String addresses = address1 + ",!" + address2 + "," + address3 + ",!" + address4;
        StringBuilder expectedSelector = new StringBuilder();
        expectedSelector.append("(((" + ManagementHelper.HDR_ADDRESS + " LIKE '" + address1 + "%')");
        expectedSelector.append(" OR ");
        expectedSelector.append("(" + ManagementHelper.HDR_ADDRESS + " LIKE '" + address3 + "%'))");
        expectedSelector.append(" AND ");
        expectedSelector.append("((" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address2 + "%')");
        expectedSelector.append(" AND ");
        expectedSelector.append("(" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address4 + "%')))");
        Assertions.assertEquals((Object)expectedSelector.toString(), (Object)ClusterConnectionBridge.createSelectorFromAddress((String)addresses));
    }

    @Test
    public void testCreateSelectorFromListIgnoresEmptyStrings() {
        String address1 = "jms.test1.address";
        String address2 = "jms.test2.address";
        String addresses = address1 + ",!" + address2 + ",,,";
        StringBuilder expectedSelector = new StringBuilder();
        expectedSelector.append("(((" + ManagementHelper.HDR_ADDRESS + " LIKE '" + address1 + "%'))");
        expectedSelector.append(" AND ");
        expectedSelector.append("((" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address2 + "%')))");
        Assertions.assertEquals((Object)expectedSelector.toString(), (Object)ClusterConnectionBridge.createSelectorFromAddress((String)addresses));
    }
}

