/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl.fakes;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;

public class FakeConsumer
implements Consumer {
    private HandleStatus statusToReturn = HandleStatus.HANDLED;
    private HandleStatus newStatus;
    private int delayCountdown = 0;
    private final LinkedList<MessageReference> references = new LinkedList();
    private final Filter filter;

    public FakeConsumer() {
        this.filter = null;
    }

    public void failed(Throwable t) {
    }

    public FakeConsumer(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String debug() {
        return this.toString();
    }

    public synchronized MessageReference waitForNextReference(long timeout) {
        while (this.references.isEmpty() && timeout > 0L) {
            long start = System.currentTimeMillis();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeout -= System.currentTimeMillis() - start;
        }
        if (timeout <= 0L) {
            throw new IllegalStateException("Timed out waiting for reference");
        }
        return this.references.removeFirst();
    }

    public synchronized void setStatusImmediate(HandleStatus newStatus) {
        this.statusToReturn = newStatus;
    }

    public synchronized void setStatusDelayed(HandleStatus newStatus, int numReferences) {
        this.newStatus = newStatus;
        this.delayCountdown = numReferences;
    }

    public long sequentialID() {
        return 0L;
    }

    public synchronized List<MessageReference> getReferences() {
        return this.references;
    }

    public synchronized void clearReferences() {
        this.references.clear();
    }

    public synchronized HandleStatus handle(MessageReference reference) {
        try {
            if (this.statusToReturn == HandleStatus.BUSY) {
                return HandleStatus.BUSY;
            }
            if (this.filter != null) {
                if (this.filter.match(reference.getMessage())) {
                    this.references.addLast(reference);
                    reference.getQueue().referenceHandled(reference);
                    this.notify();
                    return HandleStatus.HANDLED;
                }
                return HandleStatus.NO_MATCH;
            }
            if (this.newStatus != null) {
                if (this.delayCountdown == 0) {
                    this.statusToReturn = this.newStatus;
                    this.newStatus = null;
                } else {
                    --this.delayCountdown;
                }
            }
            if (this.statusToReturn == HandleStatus.HANDLED) {
                reference.getQueue().referenceHandled(reference);
                this.references.addLast(reference);
                this.notify();
            }
            return this.statusToReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void proceedDeliver(MessageReference ref) throws Exception {
    }

    public String toManagementString() {
        return this.toString();
    }

    public void disconnect() {
    }

    public List<MessageReference> getDeliveringMessages() {
        return Collections.emptyList();
    }

    public String toString() {
        if (this.filter != null) {
            return this.filter + ", " + super.toString();
        }
        return super.toString();
    }
}

