/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.logging;

import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionLoggerTest {
    @Test
    public void testHandlingOnAMQP() throws Exception {
        this.validateLogging(ActiveMQProtonRemotingConnection.class);
    }

    @Test
    public void testHandlingOnClientCore() throws Exception {
        this.validateLogging(ServerLocatorImpl.class);
    }

    @Test
    public void testInfoAMQP() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            ActiveMQAMQPProtocolLogger.LOGGER.retryConnection("test", "test", 1, 1);
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ111002"}));
        }
    }

    private void validateLogging(Class<?> clazz) throws Exception {
        int i;
        String randomLogging = RandomUtil.randomString();
        Logger logging = LoggerFactory.getLogger(clazz);
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            logging.warn(randomLogging);
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{randomLogging}));
        }
        loggerHandler = new AssertionLoggerHandler();
        try {
            for (i = 0; i < 10; ++i) {
                logging.warn(randomLogging);
            }
            Assertions.assertEquals((int)10, (int)loggerHandler.countText(new String[]{randomLogging}));
        }
        finally {
            loggerHandler.close();
        }
        loggerHandler = new AssertionLoggerHandler();
        try {
            for (i = 0; i < 10; ++i) {
                logging.info(randomLogging);
            }
            Assertions.assertEquals((int)10, (int)loggerHandler.countText(new String[]{randomLogging}));
        }
        finally {
            loggerHandler.close();
        }
    }
}

