/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.registry;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistry;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistryConfiguration;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.extension.clustering.server.registry.AbstractRegistryFactoryServiceInstallerFactory;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheRegistryFactoryServiceInstallerFactory<K, V>
extends AbstractRegistryFactoryServiceInstallerFactory<K, V> {
    public ServiceInstaller apply(CapabilityServiceSupport support, BinaryServiceConfiguration configuration) {
        final ServiceDependency group = configuration.getServiceDependency(ClusteringServiceDescriptor.GROUP).map(CacheContainerGroup.class::cast);
        final ServiceDependency cache = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        final CacheRegistryConfiguration config = new CacheRegistryConfiguration(){

            public <KK, VV> Cache<KK, VV> getCache() {
                return (Cache)cache.get();
            }

            public CacheContainerGroup getGroup() {
                return (CacheContainerGroup)group.get();
            }
        };
        Supplier<RegistryFactory<CacheContainerGroupMember, Object, Object>> factory = new Supplier<RegistryFactory<CacheContainerGroupMember, Object, Object>>(){

            @Override
            public RegistryFactory<CacheContainerGroupMember, Object, Object> get() {
                return RegistryFactory.singleton((BiFunction)new BiFunction<Map.Entry<Object, Object>, Runnable, Registry<CacheContainerGroupMember, Object, Object>>(){

                    @Override
                    public Registry<CacheContainerGroupMember, Object, Object> apply(Map.Entry<Object, Object> entry, Runnable closeTask) {
                        return new CacheRegistry(config, entry, closeTask);
                    }
                });
            }
        };
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).blocking()).provides(configuration.resolveServiceName(this.getServiceDescriptor()))).requires(List.of(group, cache))).build();
    }
}

