/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    NAME("name"),
    NUM_OWNERS("num-owners"),
    RELIABILITY("reliability");

    private static final Map<String, Attribute> ATTRIBUTES;
    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = ATTRIBUTES.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.name;
            if (name == null) continue;
            map.put(name, attribute);
        }
        ATTRIBUTES = map;
    }
}

