/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.stack.cxf.ServletControllerExt;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class CXFServletExt
extends CXFServlet {
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    private static Logger log = Logger.getLogger(CXFServletExt.class);
    protected Endpoint endpoint;
    protected EndpointRegistry epRegistry;
    protected GenericApplicationContext childCtx;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        ServletContext context = servletConfig.getServletContext();
        String contextPath = context.getContextPath();
        this.endpoint = this.initServiceEndpoint(contextPath);
        context.setAttribute(ServletController.class.getName(), (Object)this.getController());
        this.startEndpoint();
    }

    private void startEndpoint() {
        if (this.endpoint.getState() == Endpoint.EndpointState.CREATED) {
            this.endpoint.getLifecycleHandler().start(this.endpoint);
        }
    }

    private void stopEndpoint() {
        if (this.endpoint.getState() == Endpoint.EndpointState.STARTED) {
            this.endpoint.getLifecycleHandler().stop(this.endpoint);
        }
    }

    public ServletController createServletController(ServletConfig servletConfig) {
        ServletTransportFactory stf = (ServletTransportFactory)this.createServletTransportFactory();
        return new ServletControllerExt(stf, this);
    }

    public void loadBus(ServletConfig servletConfig) throws ServletException {
        super.loadBus(servletConfig);
        ServletContext svCtx = this.getServletContext();
        ApplicationContext appCtx = (ApplicationContext)svCtx.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
        this.loadAdditionalConfigExt(appCtx, servletConfig);
    }

    private void loadAdditionalConfigExt(ApplicationContext ctx, ServletConfig servletConfig) throws ServletException {
        String location = servletConfig.getServletContext().getInitParameter(PARAM_CXF_BEANS_URL);
        if (location != null) {
            InputStream is;
            try {
                is = new URL(location).openStream();
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
            this.childCtx = new GenericApplicationContext(ctx);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.childCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(is, location));
            this.childCtx.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        finally {
            EndpointAssociation.removeEndpoint();
        }
    }

    public void destroy() {
        if (this.childCtx != null) {
            this.childCtx.destroy();
        }
        this.stopEndpoint();
        super.destroy();
    }

    private Endpoint initServiceEndpoint(String contextPath) {
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        Endpoint endpoint = null;
        String servletName = this.getServletName();
        for (ObjectName sepId : this.epRegistry.getEndpoints()) {
            String propContext = sepId.getKeyProperty("context");
            String propEndpoint = sepId.getKeyProperty("endpoint");
            if (!servletName.equals(propEndpoint) || !contextPath.equals(propContext)) continue;
            endpoint = this.epRegistry.getEndpoint(sepId);
            break;
        }
        if (endpoint == null) {
            ObjectName oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName));
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
        return endpoint;
    }
}

