/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.servlet.AbstractCXFServlet;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.jboss.logging.Logger;

public class ServletControllerExt
extends ServletController {
    private static Logger log = Logger.getLogger(ServletControllerExt.class);
    private ServletTransportFactory cxfTransport;
    private CXFServlet cxfServlet;

    public ServletControllerExt(ServletTransportFactory cxfTransport, CXFServlet cxfServlet) {
        super(cxfTransport, (AbstractCXFServlet)cxfServlet);
        this.cxfTransport = cxfTransport;
        this.cxfServlet = cxfServlet;
    }

    private ServletDestination findDestination(HttpServletRequest req) throws ServletException {
        String requestURI = req.getRequestURI();
        Collection destinations = this.cxfTransport.getDestinations();
        for (ServletDestination destination : destinations) {
            EndpointInfo endpointInfo = destination.getEndpointInfo();
            String address = endpointInfo.getAddress();
            if (address.startsWith("/http://")) {
                address = address.substring(1);
                endpointInfo.setAddress(address);
            }
            String path = address;
            try {
                path = new URL(address).getPath();
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (!requestURI.startsWith(path)) continue;
            return destination;
        }
        throw new ServletException("Cannot obtain destination for: " + requestURI);
    }

    private boolean handleQuery(HttpServletRequest req, HttpServletResponse res, ServletDestination dest) throws ServletException {
        boolean queryHandlerRegistryExists;
        Bus bus = this.cxfServlet.getBus();
        boolean hasQuery = null != req.getQueryString() && req.getQueryString().length() > 0;
        boolean bl = queryHandlerRegistryExists = bus.getExtension(QueryHandlerRegistry.class) != null;
        if (hasQuery && queryHandlerRegistryExists) {
            String ctxUri = req.getRequestURI();
            String baseUri = req.getRequestURL().toString() + "?" + req.getQueryString();
            EndpointInfo endpointInfo = dest.getEndpointInfo();
            for (QueryHandler queryHandler : ((QueryHandlerRegistry)bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
                if (!queryHandler.isRecognizedQuery(baseUri, ctxUri, endpointInfo)) continue;
                res.setContentType(queryHandler.getResponseContentType(baseUri, ctxUri));
                try {
                    ServletOutputStream out = res.getOutputStream();
                    queryHandler.writeResponse(baseUri, ctxUri, endpointInfo, (OutputStream)out);
                    out.flush();
                    return true;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
        return false;
    }

    public void invoke(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ServletDestination dest = this.findDestination(req);
        boolean requestHandled = this.handleQuery(req, res, dest);
        if (!requestHandled) {
            this.invokeDestination(req, res, dest);
        }
    }
}

