/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.MTOM;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;

public class DescriptorDeploymentAspect
extends AbstractDeploymentAspect {
    private final Logger log = Logger.getLogger(DescriptorDeploymentAspect.class);
    private String invokerEJB3;
    private String invokerJSE;

    public void setInvokerEJB3(String invokerEJB3) {
        this.invokerEJB3 = invokerEJB3;
    }

    public void setInvokerJSE(String invokerJSE) {
        this.invokerJSE = invokerJSE;
    }

    public void start(Deployment dep) {
        URL cxfURL = this.getCXFConfigFromClassLoader(dep);
        if (cxfURL == null) {
            cxfURL = this.getCXFConfigFromDeployment(dep);
            if (cxfURL == null) {
                cxfURL = this.generateCXFConfigFromDeployment(dep);
            }
            this.putCXFConfigToDeployment(dep, cxfURL);
        }
    }

    public void stop(Deployment dep) {
        DDBeans dd = (DDBeans)dep.getAttachment(DDBeans.class);
        if (dd != null) {
            dd.destroyFileURL();
        }
    }

    private URL getCXFConfigFromClassLoader(Deployment dep) {
        ClassLoader initCL = dep.getInitialClassLoader();
        URL cxfURL = initCL.getResource("cxf.xml");
        if (cxfURL != null) {
            this.log.info((Object)("CXF configuration found: " + cxfURL));
        }
        return cxfURL;
    }

    private URL getCXFConfigFromDeployment(Deployment dep) {
        String metadir;
        Deployment.DeploymentType depType = dep.getType();
        if (depType == Deployment.DeploymentType.JAXWS_EJB3) {
            metadir = "META-INF";
        } else if (depType == Deployment.DeploymentType.JAXWS_JSE) {
            metadir = "WEB-INF";
        } else {
            throw new IllegalStateException("Unsupported deployment type: " + depType);
        }
        URL cxfURL = null;
        try {
            ArchiveDeployment archDep = (ArchiveDeployment)dep;
            cxfURL = archDep.getResourceResolver().resolve(metadir + "/jbossws-cxf.xml");
            this.log.info((Object)("JBossWS-CXF configuration found: " + cxfURL));
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return cxfURL;
    }

    private URL generateCXFConfigFromDeployment(Deployment dep) {
        Deployment.DeploymentType depType = dep.getType();
        DDBeans dd = new DDBeans();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            String id = ep.getShortName();
            String address = ep.getAddress();
            String implementor = ep.getTargetBeanName();
            boolean mtomEnabled = DescriptorDeploymentAspect.isMtomEnabled(ep.getTargetBeanClass());
            DDEndpoint ddep = new DDEndpoint(id, address, implementor, mtomEnabled);
            if (depType == Deployment.DeploymentType.JAXWS_EJB3) {
                ddep.setInvoker(this.invokerEJB3);
            }
            if (depType == Deployment.DeploymentType.JAXWS_JSE) {
                ddep.setInvoker(this.invokerJSE);
            }
            this.log.info((Object)("Add " + ddep));
            dd.addEndpoint(ddep);
        }
        URL cxfURL = dd.createFileURL();
        this.log.info((Object)("JBossWS-CXF configuration generated: " + cxfURL));
        dep.addAttachment(DDBeans.class, (Object)dd);
        return cxfURL;
    }

    private void putCXFConfigToDeployment(Deployment dep, URL cxfURL) {
        HashMap<String, String> contextParams = (HashMap<String, String>)dep.getProperty("stack.context.parameters");
        if (contextParams == null) {
            contextParams = new HashMap<String, String>();
            dep.setProperty("stack.context.parameters", contextParams);
        }
        contextParams.put("jbossws.cxf.beans.url", cxfURL.toExternalForm());
    }

    private static boolean isMtomEnabled(Class<?> beanClass) {
        boolean mtomEnabled;
        BindingType bindingType = beanClass.getAnnotation(BindingType.class);
        MTOM mtom = beanClass.getAnnotation(MTOM.class);
        boolean bl = mtomEnabled = mtom != null;
        if (!mtomEnabled && bindingType != null) {
            String binding = bindingType.value();
            mtomEnabled = binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        }
        return mtomEnabled;
    }
}

