/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.stack.cxf.ServletControllerExt;
import org.jboss.wsf.stack.cxf.SoapTransportFactoryExt;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSCXFConfigurer;
import org.jboss.wsf.stack.cxf.management.InstrumentationManagerExtImpl;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class CXFServletExt
extends CXFServlet {
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    public static final String ENABLE_CXF_MANAGEMENT = "enable.cxf.management";
    public static final String JMS_NS = "http://cxf.apache.org/transports/jms";
    private static Logger log = Logger.getLogger(CXFServletExt.class);
    protected Endpoint endpoint;
    protected EndpointRegistry epRegistry;
    protected GenericApplicationContext childCtx;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public ServletController createServletController(ServletConfig servletConfig) {
        ServletTransportFactory stf = (ServletTransportFactory)this.createServletTransportFactory();
        return new ServletControllerExt(stf, servletConfig, servletConfig.getServletContext(), this.bus);
    }

    public void loadBus(ServletConfig servletConfig) throws ServletException {
        super.loadBus(servletConfig);
        ServletContext svCtx = this.getServletContext();
        ApplicationContext appCtx = (ApplicationContext)svCtx.getAttribute("org.springframework.web.context.WebApplicationContext.ROOT");
        Bus bus = this.getBus();
        if (svCtx.getInitParameter(ENABLE_CXF_MANAGEMENT) != null && "true".equalsIgnoreCase(svCtx.getInitParameter(ENABLE_CXF_MANAGEMENT))) {
            this.registerInstrumentManger(bus);
        }
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        SoapTransportFactoryExt factory = new SoapTransportFactoryExt();
        factory.setBus(bus);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)factory);
        dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap12/", (DestinationFactory)factory);
        this.initEndpoint(servletConfig);
        this.loadAdditionalConfigExt(appCtx, servletConfig);
    }

    private void initEndpoint(ServletConfig servletConfig) {
        BindingCustomization customization;
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        ServletContext context = servletConfig.getServletContext();
        String contextPath = context.getContextPath();
        this.endpoint = this.initServiceEndpoint(contextPath);
        ResourceResolver resourceResolver = (ResourceResolver)this.endpoint.getAttachment(ResourceResolver.class);
        if (resourceResolver != null) {
            ((ResourceManager)this.bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
        if ((customization = (BindingCustomization)this.endpoint.getAttachment(BindingCustomization.class)) != null) {
            JBossWSCXFConfigurer jbosswsConfigurer = new JBossWSCXFConfigurer((Configurer)this.bus.getExtension(Configurer.class));
            jbosswsConfigurer.setBindingCustomization((BindingCustomization)this.endpoint.getAttachment(BindingCustomization.class));
            this.bus.setExtension((Object)jbosswsConfigurer, Configurer.class);
        }
        context.setAttribute(ServletController.class.getName(), (Object)this.getController());
    }

    private void loadAdditionalConfigExt(ApplicationContext ctx, ServletConfig servletConfig) throws ServletException {
        String location = servletConfig.getServletContext().getInitParameter(PARAM_CXF_BEANS_URL);
        if (location != null) {
            InputStream is;
            try {
                is = new URL(location).openStream();
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
            this.childCtx = new GenericApplicationContext(ctx);
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.childCtx);
            reader.setValidationMode(3);
            reader.loadBeanDefinitions((Resource)new InputStreamResource(is, location));
            this.childCtx.refresh();
        }
    }

    protected void invoke(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        try {
            BusFactory.setThreadDefaultBus((Bus)this.getBus());
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        catch (IOException ioe) {
            throw new ServletException((Throwable)ioe);
        }
        finally {
            EndpointAssociation.removeEndpoint();
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public void destroy() {
        if (this.childCtx != null) {
            this.childCtx.destroy();
        }
        super.destroy();
    }

    private Endpoint initServiceEndpoint(String contextPath) {
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        Endpoint endpoint = null;
        String servletName = this.getServletName();
        for (ObjectName sepId : this.epRegistry.getEndpoints()) {
            String propContext = sepId.getKeyProperty("context");
            String propEndpoint = sepId.getKeyProperty("endpoint");
            if (!servletName.equals(propEndpoint) || !contextPath.equals(propContext)) continue;
            endpoint = this.epRegistry.getEndpoint(sepId);
            break;
        }
        if (endpoint == null) {
            ObjectName oname = ObjectNameFactory.create((String)("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName));
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
        return endpoint;
    }

    private void registerInstrumentManger(Bus bus) throws ServletException {
        InstrumentationManagerExtImpl instrumentationManagerImpl = new InstrumentationManagerExtImpl();
        instrumentationManagerImpl.setBus(bus);
        instrumentationManagerImpl.setEnabled(true);
        instrumentationManagerImpl.initMBeanServer();
        instrumentationManagerImpl.register();
        bus.setExtension((Object)instrumentationManagerImpl, InstrumentationManager.class);
        CounterRepository couterRepository = new CounterRepository();
        couterRepository.setBus(bus);
        try {
            Method method = CounterRepository.class.getDeclaredMethod("registerInterceptorsToBus", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)couterRepository, new Object[0]);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

