/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.w3c.dom.Element;

public abstract class AbstractInvoker
implements Invoker {
    private static final Object[] NO_ARGS = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object o) {
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage(), MessageContext.Scope.APPLICATION);
        Map<String, Object> handlerScopedStuff = this.removeHandlerProperties(ctx);
        WebServiceContextImpl.setMessageContext((MessageContext)ctx);
        Object retObj = null;
        try {
            retObj = this._invokeInternal(exchange, o, ctx);
            this.addHandlerProperties(ctx, handlerScopedStuff);
            this.updateWebServiceContext(exchange, (MessageContext)ctx);
        }
        finally {
            WebServiceContextImpl.clear();
        }
        return new MessageContentsList(new Object[]{retObj});
    }

    private Object _invokeInternal(Exchange exchange, Object o, WrappedMessageContext ctx) {
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        MethodDispatcher md = (MethodDispatcher)((Service)exchange.get(Service.class)).get((Object)MethodDispatcher.class.getName());
        Method m = md.getMethod(bop);
        Object[] params = NO_ARGS;
        List paramList = null;
        if (m.getParameterTypes().length != 0) {
            if (o instanceof List) {
                paramList = CastUtils.cast((List)((List)o));
                params = paramList.toArray();
            } else {
                params = new Object[]{o};
            }
        }
        org.jboss.wsf.spi.deployment.Endpoint ep = EndpointAssociation.getEndpoint();
        InvocationHandler invHandler = ep.getInvocationHandler();
        Invocation inv = invHandler.createInvocation();
        InvocationContext invContext = inv.getInvocationContext();
        inv.getInvocationContext().addAttachment(WebServiceContext.class, (Object)this.getWebServiceContext((MessageContext)ctx));
        invContext.addAttachment(MessageContext.class, (Object)ctx);
        inv.setJavaMethod(m);
        inv.setArgs(params);
        Object retObj = null;
        try {
            invHandler.invoke(ep, inv);
            retObj = inv.getReturnValue();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t == null) {
                t = e;
            }
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            for (Class<?> cl : m.getExceptionTypes()) {
                if (!cl.isInstance(t)) continue;
                exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
            }
            if (t instanceof Fault) {
                exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
                throw (Fault)t;
            }
            throw this.createFault(t, m, paramList, true);
        }
        catch (Fault f) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw f;
        }
        catch (Exception e) {
            exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
            throw this.createFault(e, m, paramList, false);
        }
        return retObj;
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    protected Fault createFault(Throwable ex, Method m, List<Object> params, boolean checked) {
        SOAPFaultException sfe = this.findSoapFaultException(ex);
        if (sfe != null) {
            SoapFault fault = new SoapFault(sfe.getFault().getFaultString(), (Throwable)sfe, sfe.getFault().getFaultCodeAsQName());
            fault.setRole(sfe.getFault().getFaultActor());
            fault.setDetail((Element)sfe.getFault().getDetail());
            return fault;
        }
        return new Fault(ex);
    }

    protected abstract WebServiceContext getWebServiceContext(MessageContext var1);

    protected Map<String, Object> removeHandlerProperties(WrappedMessageContext ctx) {
        Map scopes = CastUtils.cast((Map)((Map)ctx.get((Object)WrappedMessageContext.SCOPES)));
        HashMap<String, Object> handlerScopedStuff = new HashMap<String, Object>();
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                handlerScopedStuff.put((String)scope.getKey(), ctx.get(scope.getKey()));
            }
            for (String key : handlerScopedStuff.keySet()) {
                ctx.remove((Object)key);
            }
        }
        return handlerScopedStuff;
    }

    protected void updateWebServiceContext(Exchange exchange, MessageContext ctx) {
        SoapMessage sm;
        List list;
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty() && (sm = (SoapMessage)this.createResponseMessage(exchange)) != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sm.getHeaders().add((Header)iter.next());
            }
        }
        if (exchange.getOutMessage() != null) {
            Map dataHandlers;
            Map heads;
            Message out = exchange.getOutMessage();
            if (out.containsKey((Object)Message.PROTOCOL_HEADERS) && (heads = CastUtils.cast((Map)((Map)exchange.getOutMessage().get((Object)Message.PROTOCOL_HEADERS)))).containsKey("Content-Type")) {
                List ct = (List)heads.get("Content-Type");
                exchange.getOutMessage().put((Object)"Content-Type", ct.get(0));
                heads.remove("Content-Type");
            }
            if ((dataHandlers = CastUtils.cast((Map)((Map)out.get((Object)"javax.xml.ws.binding.attachments.outbound")))) != null && !dataHandlers.isEmpty()) {
                ArrayList<AttachmentImpl> attachments = out.getAttachments();
                if (attachments == null) {
                    attachments = new ArrayList<AttachmentImpl>();
                    out.setAttachments(attachments);
                }
                for (Map.Entry entry : dataHandlers.entrySet()) {
                    AttachmentImpl att = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
                    attachments.add(att);
                }
            }
            out.remove((Object)"javax.xml.ws.binding.attachments.outbound");
        }
    }

    private Message createResponseMessage(Exchange exchange) {
        if (exchange == null) {
            return null;
        }
        Message m = exchange.getOutMessage();
        if (m == null && !exchange.isOneWay()) {
            Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
            m = ep.getBinding().createMessage();
            exchange.setOutMessage(m);
        }
        return m;
    }

    protected void addHandlerProperties(WrappedMessageContext ctx, Map<String, Object> handlerScopedStuff) {
        for (Map.Entry<String, Object> key : handlerScopedStuff.entrySet()) {
            ctx.put(key.getKey(), key.getValue(), MessageContext.Scope.HANDLER);
        }
    }
}

