/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.security.AuthenticationManager;
import org.picketbox.factories.SecurityFactory;

public class AuthenticationManagerLoader {
    public AuthenticationManager getManagerWithJndi() {
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup("java:/comp/env/security/securityMgr");
            return (AuthenticationManager)obj;
        }
        catch (NamingException ne) {
            throw new SecurityException("Unable to lookup AuthenticationManager using JNDI");
        }
    }

    public AuthenticationManager getManager(String securityDomainName) {
        SecurityFactory.prepare();
        try {
            AuthenticationManager authenticationManager = SecurityFactory.getAuthenticationManager((String)securityDomainName);
            return authenticationManager;
        }
        catch (Exception ex) {
            throw new SecurityException("Unable to get Authentication Manager", ex);
        }
        finally {
            SecurityFactory.release();
        }
    }
}

