/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.List;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringConfigurer;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.ServerBeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;

public class NonSpringBusHolder
extends BusHolder {
    private boolean configured = false;
    protected DDBeans metadata;

    public NonSpringBusHolder(DDBeans metadata) {
        this.metadata = metadata;
        this.bus = new JBossWSNonSpringBusFactory().createBus();
        ExtensionManager em = (ExtensionManager)this.bus.getExtension(ExtensionManager.class);
        em.activateAllByType(ConduitInitiator.class);
        ServletTransportFactory factory = new ServletTransportFactory(this.bus);
        for (String s : factory.getTransportIds()) {
            this.registerTransport((DestinationFactory)factory, s);
        }
    }

    @Override
    public void configure(SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer) {
        if (this.configured) {
            throw new IllegalStateException("Underlying bus is already configured for JBossWS use!");
        }
        super.configure(soapTransportFactory, resolver, configurer);
        for (DDEndpoint dde : this.metadata.getEndpoints()) {
            EndpointImpl endpoint = new EndpointImpl(this.bus, NonSpringBusHolder.newInstance(dde.getImplementor()));
            endpoint.setInvoker((Invoker)NonSpringBusHolder.newInstance(dde.getInvoker()));
            endpoint.setAddress(dde.getAddress());
            endpoint.setEndpointName(dde.getPortName());
            endpoint.setServiceName(dde.getServiceName());
            endpoint.setWsdlLocation(dde.getWsdlLocation());
            endpoint.publish();
            if (!dde.isMtomEnabled()) continue;
            SOAPBinding binding = (SOAPBinding)endpoint.getBinding();
            binding.setMTOMEnabled(true);
        }
        this.configured = true;
    }

    private static Object newInstance(String className) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher, List<Endpoint> depEndpoints) {
        ServerBeanCustomizer customizer = new ServerBeanCustomizer();
        customizer.setBindingCustomization(customization);
        customizer.setWsdlPublisher(wsdlPublisher);
        customizer.setDeploymentEndpoints(depEndpoints);
        return new JBossWSNonSpringConfigurer((BeanCustomizer)customizer);
    }
}

