/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSDestination;
import org.jboss.wsf.common.integration.JMSDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;
import org.springframework.jms.connection.SingleConnectionFactory;

public class JMSEndpointDeploymentAspectDelegate
extends JMSDeploymentAspect {
    private BusHolder busHolder = null;

    public void start(Deployment dep) {
        if (dep.getAttachment(JMSEndpointsMetaData.class) != null) {
            JMSEndpointsMetaData jmsEndpoints = (JMSEndpointsMetaData)dep.getAttachment(JMSEndpointsMetaData.class);
            URL url = jmsEndpoints.getDescriptorURL();
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(dep.getRuntimeClassLoader());
                SpringBusFactory bf = new SpringBusFactory();
                Bus bus = bf.createBus(url);
                dep.addAttachment(Bus.class, (Object)bus);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to deploy jms endpoints deployment " + url));
                throw new RuntimeException(e);
            }
            finally {
                BusFactory.setDefaultBus(null);
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    public void stop(Deployment dep) {
        this.log.debug((Object)("Undeploying jms endpoints in " + dep.getSimpleName()));
        if (this.busHolder != null && this.busHolder.getBus() != null) {
            SingleConnectionFactory connectionFactory = null;
            Server jmsServer = null;
            ServerRegistry serRegistry = (ServerRegistry)this.busHolder.getBus().getExtension(ServerRegistry.class);
            for (Server server : serRegistry.getServers()) {
                JMSDestination jmsDestination;
                JMSConfiguration jmsConfig;
                if (server.getDestination() == null || !(server.getDestination() instanceof JMSDestination) || (jmsConfig = (jmsDestination = (JMSDestination)server.getDestination()).getJmsConfig()).getWrappedConnectionFactory() == null || !(jmsConfig.getWrappedConnectionFactory() instanceof SingleConnectionFactory)) continue;
                connectionFactory = (SingleConnectionFactory)jmsConfig.getWrappedConnectionFactory();
                jmsServer = server;
            }
            if (jmsServer != null) {
                jmsServer.stop();
            }
            if (connectionFactory != null) {
                connectionFactory.destroy();
            }
            this.busHolder.getBus().shutdown(false);
            this.busHolder.close();
        }
    }
}

