/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.jboss.wsf.stack.cxf.transport.TomcatHTTPDestination;

public class TomcatHTTPTransportFactory
extends AbstractHTTPTransportFactory
implements DestinationFactory {
    private Map<String, TomcatHTTPDestination> destinations = new HashMap<String, TomcatHTTPDestination>();

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        String addr = endpointInfo.getAddress();
        TomcatHTTPDestination destination = this.destinations.get(addr);
        if (destination == null) {
            destination = this.createDestination(endpointInfo);
        }
        return destination;
    }

    private synchronized TomcatHTTPDestination createDestination(EndpointInfo endpointInfo) throws IOException {
        TomcatHTTPDestination destination = this.destinations.get(endpointInfo.getAddress());
        if (destination == null) {
            destination = new TomcatHTTPDestination(this.getBus(), this, endpointInfo, true);
            this.destinations.put(endpointInfo.getAddress(), destination);
            this.configure((Object)destination);
        }
        return destination;
    }

    void removeDestination(EndpointInfo ei) {
        this.destinations.remove(ei.getAddress());
    }
}

