/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.metadata;

import java.util.LinkedList;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.MTOM;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;

public class MetadataBuilder {
    private static final Logger log = Logger.getLogger(MetadataBuilder.class);

    public DDBeans build(Deployment dep, String invokerEJB3, String invokerJSE) {
        Deployment.DeploymentType depType = dep.getType();
        DDBeans dd = new DDBeans();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            DDEndpoint ddep = this.createDDEndpoint(ep.getTargetBeanClass(), (ArchiveDeployment)dep, ep);
            if (depType == Deployment.DeploymentType.JAXWS_EJB3) {
                ddep.setInvoker(invokerEJB3);
            }
            if (depType == Deployment.DeploymentType.JAXWS_JSE) {
                ddep.setInvoker(invokerJSE);
            }
            this.processWSDDContribution(ddep, (ArchiveDeployment)dep);
            log.info((Object)("Add " + ddep));
            dd.addEndpoint(ddep);
        }
        return dd;
    }

    protected boolean isMtomEnabled(Class<?> beanClass) {
        boolean mtomEnabled;
        BindingType bindingType = beanClass.getAnnotation(BindingType.class);
        MTOM mtom = beanClass.getAnnotation(MTOM.class);
        boolean bl = mtomEnabled = mtom != null;
        if (!mtomEnabled && bindingType != null) {
            String binding = bindingType.value();
            mtomEnabled = binding.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true") || binding.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        }
        return mtomEnabled;
    }

    private void processWSDDContribution(DDEndpoint endpoint, ArchiveDeployment dep) {
        WebservicesMetaData webservices = WebservicesFactory.loadFromVFSRoot((UnifiedVirtualFile)dep.getRootFile());
        if (webservices != null) {
            for (WebserviceDescriptionMetaData wsDesc : webservices.getWebserviceDescriptions()) {
                for (PortComponentMetaData portComp : wsDesc.getPortComponents()) {
                    String wsdlFile;
                    UnifiedHandlerChainsMetaData chainWrapper;
                    boolean doesMatch;
                    String portCompSEI = portComp.getServiceEndpointInterface();
                    boolean bl = doesMatch = portCompSEI != null ? portCompSEI.equals(endpoint.getEpClass().getName()) : false;
                    if (!doesMatch) {
                        doesMatch = portComp.getWsdlPort().equals(endpoint.getPortName());
                    }
                    if (!doesMatch) continue;
                    if (portComp.getWsdlPort() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Override portName " + endpoint.getPortName() + " with " + portComp.getWsdlPort()));
                        }
                        endpoint.setPortName(portComp.getWsdlPort());
                    }
                    if (portComp.getWsdlService() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Override serviceName " + endpoint.getServiceName() + " with " + portComp.getWsdlService()));
                        }
                        endpoint.setServiceName(portComp.getWsdlService());
                    }
                    if ((chainWrapper = portComp.getHandlerChains()) != null) {
                        LinkedList<String> handlers = new LinkedList<String>();
                        for (UnifiedHandlerChainMetaData handlerChain : chainWrapper.getHandlerChains()) {
                            if (handlerChain.getPortNamePattern() != null || handlerChain.getProtocolBindings() != null || handlerChain.getServiceNamePattern() != null) {
                                log.warn((Object)"PortNamePattern, ServiceNamePattern and ProtocolBindings filters not supported; adding handlers anyway.");
                            }
                            for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Contribute handler from webservices.xml: " + uhmd.getHandlerName()));
                                }
                                if (uhmd.getInitParams() != null && !uhmd.getInitParams().isEmpty()) {
                                    log.warn((Object)"Init params not supported.");
                                }
                                handlers.add(uhmd.getHandlerClass());
                            }
                        }
                        endpoint.setHandlers(handlers);
                    }
                    if (portComp.isEnableMtom()) {
                        log.debug((Object)"Enabling MTOM");
                        endpoint.setMtomEnabled(true);
                    }
                    if ((wsdlFile = portComp.getWebserviceDescription().getWsdlFile()) == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Override wsdlFile location with " + wsdlFile));
                    }
                    endpoint.setWsdlLocation(wsdlFile);
                }
            }
        }
    }

    protected DDEndpoint createDDEndpoint(Class<?> sepClass, ArchiveDeployment dep, Endpoint ep) {
        String portName;
        String serviceNS;
        String serviceName;
        String name;
        WebService anWebService = sepClass.getAnnotation(WebService.class);
        WebServiceProvider anWebServiceProvider = sepClass.getAnnotation(WebServiceProvider.class);
        Class<?> seiClass = null;
        String string = name = anWebService != null ? anWebService.name() : "";
        if (name.length() == 0) {
            name = JavaUtils.getJustClassName(sepClass);
        }
        String string2 = serviceName = anWebService != null ? anWebService.serviceName() : anWebServiceProvider.serviceName();
        if (serviceName.length() == 0) {
            serviceName = JavaUtils.getJustClassName(sepClass) + "Service";
        }
        String string3 = serviceNS = anWebService != null ? anWebService.targetNamespace() : anWebServiceProvider.targetNamespace();
        if (serviceNS.length() == 0) {
            serviceNS = MetadataBuilder.getTypeNamespace(JavaUtils.getPackageName(sepClass));
        }
        String string4 = portName = anWebService != null ? anWebService.portName() : anWebServiceProvider.portName();
        if (portName.length() == 0) {
            portName = name + "Port";
        }
        if (anWebService != null && anWebService.endpointInterface().length() > 0) {
            String seiName = anWebService.endpointInterface();
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw new IllegalArgumentException("Runtime loader cannot be null");
            }
            try {
                seiClass = runtimeClassLoader.loadClass(seiName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Cannot load service endpoint interface class!", cnfe);
            }
            WebService seiAnnotation = seiClass.getAnnotation(WebService.class);
            if (seiAnnotation == null) {
                throw new RuntimeException("Interface does not have a @WebService annotation: " + seiName);
            }
            if (seiAnnotation.portName().length() > 0 || seiAnnotation.serviceName().length() > 0 || seiAnnotation.endpointInterface().length() > 0) {
                throw new RuntimeException("@WebService cannot have attribute 'portName', 'serviceName', 'endpointInterface' on: " + seiName);
            }
        }
        DDEndpoint result = new DDEndpoint();
        result.setId(ep.getShortName());
        result.setAddress(ep.getAddress());
        result.setImplementor(ep.getTargetBeanName());
        result.setMtomEnabled(this.isMtomEnabled(ep.getTargetBeanClass()));
        result.setEpClass(seiClass != null ? seiClass : sepClass);
        result.setPortName(new QName(serviceNS, portName));
        result.setServiceName(new QName(serviceNS, serviceName));
        return result;
    }

    private static String getTypeNamespace(String packageName) {
        String next;
        StringBuilder sb = new StringBuilder("http://");
        StringTokenizer st = new StringTokenizer(packageName, ".");
        Stack<String> stk = new Stack<String>();
        while (st != null && st.hasMoreTokens()) {
            stk.push(st.nextToken());
        }
        while (!stk.isEmpty() && (next = (String)stk.pop()) != null) {
            if (!sb.toString().equals("http://")) {
                sb.append('.');
            }
            sb.append(next);
        }
        sb.append('/');
        return sb.toString();
    }
}

