/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.spring.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;

public class NamespaceHandlerResolver
extends DefaultNamespaceHandlerResolver {
    public static final String JBOSSWS_HANDLER_MAPPINGS_LOCATION = "META-INF/jbossws.spring.handlers";
    private static final Logger logger = Logger.getLogger(NamespaceHandlerResolver.class);
    private ClassLoader loader;
    private Map<Object, Object> jbosswsHandlerMappings;

    public NamespaceHandlerResolver() {
    }

    public NamespaceHandlerResolver(ClassLoader classLoader) {
        super(classLoader);
        this.loader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public NamespaceHandlerResolver(ClassLoader classLoader, String handlerMappingsLocation) {
        super(classLoader, handlerMappingsLocation);
        this.loader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    public NamespaceHandler resolve(String namespaceUri) {
        NamespaceHandler jbosswsHandler;
        block2: {
            jbosswsHandler = null;
            try {
                jbosswsHandler = this.resolveInternal(namespaceUri);
            }
            catch (Throwable t) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace((Object)("Unable to resolve JBossWS specific handler for namespace '" + namespaceUri + "'; trying default namespace resolution..."), t);
            }
        }
        return jbosswsHandler != null ? jbosswsHandler : super.resolve(namespaceUri);
    }

    private NamespaceHandler resolveInternal(String namespaceUri) {
        Map<Object, Object> handlerMappings = this.getHandlerMappings();
        Object handlerOrClassName = handlerMappings.get(namespaceUri);
        if (handlerOrClassName == null) {
            return null;
        }
        if (handlerOrClassName instanceof NamespaceHandler) {
            return (NamespaceHandler)handlerOrClassName;
        }
        String className = (String)handlerOrClassName;
        try {
            Class handlerClass = ClassUtils.forName((String)className, (ClassLoader)this.loader);
            if (!NamespaceHandler.class.isAssignableFrom(handlerClass)) {
                throw new FatalBeanException("Class [" + className + "] for namespace [" + namespaceUri + "] does not implement the [" + NamespaceHandler.class.getName() + "] interface");
            }
            NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass((Class)handlerClass);
            namespaceHandler.init();
            handlerMappings.put(namespaceUri, namespaceHandler);
            return namespaceHandler;
        }
        catch (ClassNotFoundException ex) {
            throw new FatalBeanException("NamespaceHandler class [" + className + "] for namespace [" + namespaceUri + "] not found", (Throwable)ex);
        }
        catch (LinkageError err) {
            throw new FatalBeanException("Invalid NamespaceHandler class [" + className + "] for namespace [" + namespaceUri + "]: problem with handler class file or dependent class", (Throwable)err);
        }
    }

    private Map<Object, Object> getHandlerMappings() {
        if (this.jbosswsHandlerMappings == null) {
            try {
                Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)JBOSSWS_HANDLER_MAPPINGS_LOCATION, (ClassLoader)this.loader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loaded mappings [" + mappings + "]"));
                }
                this.jbosswsHandlerMappings = new HashMap<Object, Object>(mappings);
            }
            catch (IOException ex) {
                IllegalStateException ise = new IllegalStateException("Unable to load NamespaceHandler mappings from location [META-INF/jbossws.spring.handlers]");
                ise.initCause(ex);
                throw ise;
            }
        }
        return this.jbosswsHandlerMappings;
    }
}

