/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.stack.cxf.AbstractInvoker;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class ServerBeanCustomizer
extends BeanCustomizer {
    private WSDLFilePublisher wsdlPublisher;
    private List<Endpoint> depEndpoints;
    private UnifiedVirtualFile deploymentRoot;

    public void customize(Object beanInstance) {
        if (beanInstance instanceof EndpointImpl) {
            this.configureEndpoint((EndpointImpl)((Object)beanInstance));
        }
        if (beanInstance instanceof ServerFactoryBean) {
            ServerFactoryBean factory = (ServerFactoryBean)beanInstance;
            if (factory.getInvoker() instanceof AbstractInvoker) {
                ((AbstractInvoker)factory.getInvoker()).setTargetBean(factory.getServiceBean());
            }
            if (this.depEndpoints != null) {
                for (Endpoint depEndpoint : this.depEndpoints) {
                    if (!depEndpoint.getTargetBeanClass().isAssignableFrom(factory.getServiceBean().getClass())) continue;
                    depEndpoint.addAttachment(ServerFactoryBean.class, (Object)factory);
                }
            }
        }
        super.customize(beanInstance);
    }

    protected void configureEndpoint(EndpointImpl endpoint) {
        Object implementor;
        EndpointConfig epConfig;
        if (this.wsdlPublisher != null) {
            endpoint.setWsdlPublisher(this.wsdlPublisher);
        }
        if (!endpoint.isPublished() && (epConfig = (implementor = endpoint.getImplementor()).getClass().getAnnotation(EndpointConfig.class)) != null) {
            String configFile = epConfig.configFile();
            try {
                UnifiedVirtualFile vf = this.deploymentRoot.findChild(configFile);
                ConfigRoot config = ConfigMetaDataParser.parse((URL)vf.toURL());
                endpoint.setEndpointConfig((CommonConfig)config.getEndpointConfigByName(epConfig.configName()));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not find " + configFile);
            }
        }
    }

    public void setDeploymentRoot(UnifiedVirtualFile deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    public void setDeploymentEndpoints(List<Endpoint> endpoints) {
        this.depEndpoints = endpoints;
    }
}

