/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.stack.cxf.security.authentication.AuthenticationManagerLoader;
import org.jboss.wsf.stack.cxf.security.authentication.callback.UsernameTokenCallbackHandler;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;
import org.jboss.xb.binding.SimpleTypeBindings;

public class SubjectCreatingInterceptor
extends AbstractUsernameTokenAuthenticatingInterceptor {
    private static final Logger log = Logger.getLogger(SubjectCreatingInterceptor.class);
    private static final int TIMESTAMP_FRESHNESS_THRESHOLD = 300;
    private AuthenticationManagerLoader aml;
    private boolean propagateContext;
    private SecurityAdaptorFactory secAdaptorFactory;
    private int timestampThreshold = 300;
    private NonceStore nonceStore;
    private boolean decodeNonce = true;

    public SubjectCreatingInterceptor() {
        this(new HashMap<String, Object>());
    }

    public SubjectCreatingInterceptor(Map<String, Object> properties) {
        super(properties);
        try {
            this.aml = (AuthenticationManagerLoader)AuthenticationManagerLoader.class.newInstance();
        }
        catch (Exception ex) {
            String msg = "AuthenticationManager can not be loaded";
            log.error((Object)msg);
            throw new SecurityException(msg);
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.secAdaptorFactory = (SecurityAdaptorFactory)spiProvider.getSPI(SecurityAdaptorFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) {
        if (isDigest) {
            this.verifyUsernameToken(nonce, created);
            UsernameTokenCallbackHandler handler = new UsernameTokenCallbackHandler(nonce, created, this.decodeNonce);
            CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
        }
        AuthenticationManager am = this.aml.getManager();
        SimplePrincipal principal = new SimplePrincipal(name);
        Subject subject = new Subject();
        boolean TRACE = log.isTraceEnabled();
        if (TRACE) {
            log.trace((Object)("About to authenticate, using security domain '" + am.getSecurityDomain() + "'"));
        }
        try {
            if (!am.isValid((Principal)principal, (Object)password, subject)) {
                String msg = "Authentication failed, principal=" + principal.getName();
                log.error((Object)msg);
                throw new SecurityException(msg);
            }
        }
        finally {
            if (isDigest) {
                CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
            }
        }
        if (TRACE) {
            log.trace((Object)("Authenticated, principal=" + name));
        }
        if (this.propagateContext) {
            SecurityAdaptor adaptor = this.secAdaptorFactory.newSecurityAdapter();
            adaptor.pushSubjectContext(subject, (Principal)principal, (Object)password);
            if (TRACE) {
                log.trace((Object)"Security Context has been propagated");
            }
        }
        return subject;
    }

    private void verifyUsernameToken(String nonce, String created) {
        if (created != null) {
            Calendar cal = SimpleTypeBindings.unmarshalDateTime((String)created);
            Calendar ref = Calendar.getInstance();
            ref.add(13, -this.timestampThreshold);
            if (ref.after(cal)) {
                throw new SecurityException("Request rejected since a stale timestamp has been provided: " + created);
            }
        }
        if (nonce != null && this.nonceStore != null) {
            if (this.nonceStore.hasNonce(nonce)) {
                throw new SecurityException("Request rejected since a message with the same nonce has been recently received; nonce = " + nonce);
            }
            this.nonceStore.putNonce(nonce);
        }
    }

    public void setPropagateContext(boolean propagateContext) {
        this.propagateContext = propagateContext;
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.timestampThreshold = timestampThreshold;
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.nonceStore = nonceStore;
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.decodeNonce = decodeNonce;
    }
}

