/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.service.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.stack.cxf.deployment.SecurityActions;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class EndpointImpl
extends org.apache.cxf.jaxws22.EndpointImpl {
    private WSDLFilePublisher wsdlPublisher;
    private CommonConfig config;

    public EndpointImpl(Object implementor) {
        super(implementor);
    }

    public EndpointImpl(Bus bus, Object implementor) {
        super(bus, implementor);
    }

    protected void doPublish(String addr) {
        super.getServerFactory().setBlockPostConstruct(true);
        super.doPublish(addr);
        this.configureObject((Object)this);
        this.sortConfigHandlers();
        this.publishContractToFilesystem();
    }

    public void setEndpointConfig(CommonConfig config) {
        if (this.config == null) {
            this.config = config;
            Map epConfProps = config.getProperties();
            if (!epConfProps.isEmpty()) {
                if (this.getProperties() == null) {
                    HashMap props = new HashMap();
                    props.putAll(epConfProps);
                    this.setProperties(props);
                } else {
                    this.getProperties().putAll(epConfProps);
                }
            }
            List<Handler> handlers = this.convertToHandlers(config.getPreHandlerChains());
            handlers.addAll(this.convertToHandlers(config.getPostHandlerChains()));
            if (!handlers.isEmpty()) {
                if (this.getHandlers() != null) {
                    handlers.addAll(this.getHandlers());
                }
                this.setHandlers(handlers);
            }
        }
    }

    protected List<Handler> convertToHandlers(List<UnifiedHandlerChainMetaData> handlerChains) {
        LinkedList<Handler> handlers = new LinkedList<Handler>();
        if (handlerChains != null && !handlerChains.isEmpty()) {
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (handlerChain.getPortNamePattern() != null || handlerChain.getProtocolBindings() != null || handlerChain.getServiceNamePattern() != null) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"PortNamePattern, ServiceNamePattern and ProtocolBindings filters not supported; adding handlers anyway.");
                }
                for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                    Object h;
                    if (uhmd.getInitParams() != null && !uhmd.getInitParams().isEmpty()) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"Init params not supported.");
                    }
                    if ((h = EndpointImpl.newInstance(uhmd.getHandlerClass())) == null) continue;
                    if (h instanceof Handler) {
                        handlers.add((Handler)h);
                        continue;
                    }
                    throw new RuntimeException(h + " is not a JAX-WS Handler instance!");
                }
            }
        }
        return handlers;
    }

    private static Object newInstance(String className) {
        try {
            DelegateClassLoader loader = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), SecurityActions.getContextClassLoader());
            Class<?> clazz = loader.loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            Logger.getLogger(EndpointImpl.class).warnf((Throwable)e, "Could not add handler '%s' as part of endpoint configuration", (Object)className);
            return null;
        }
    }

    protected void sortConfigHandlers() {
        if (this.config != null && this.config.getPostHandlerChains() != null) {
            LinkedList<String> postHandlerNames = new LinkedList<String>();
            for (UnifiedHandlerChainMetaData uhcm : this.config.getPostHandlerChains()) {
                for (UnifiedHandlerMetaData uhm : uhcm.getHandlers()) {
                    postHandlerNames.add(uhm.getHandlerClass());
                }
            }
            if (!postHandlerNames.isEmpty()) {
                LinkedList<Object> newHandlers = new LinkedList<Object>();
                LinkedList<Handler> postHandlers = new LinkedList<Handler>();
                List handlers = this.getBinding().getHandlerChain();
                for (Handler h : handlers) {
                    if (postHandlerNames.contains(h.getClass().getName())) {
                        postHandlers.add(h);
                        continue;
                    }
                    newHandlers.add(h);
                }
                newHandlers.addAll(postHandlers);
                this.getBinding().setHandlerChain(newHandlers);
            }
        }
    }

    protected void publishContractToFilesystem() {
        if (this.wsdlPublisher != null) {
            Endpoint endpoint = this.getServer().getEndpoint();
            Service service = endpoint.getService();
            try {
                JaxWsImplementorInfo info = new JaxWsImplementorInfo(this.getImplementorClass());
                this.wsdlPublisher.publishWsdlFiles(service.getName(), info.getWsdlLocation(), BusFactory.getThreadDefaultBus((boolean)false), service.getServiceInfos());
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while publishing wsdl for service " + service.getName(), ioe);
            }
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass()).warn((Object)"WSDLPublisher not configured, unable to publish contract!");
        }
    }

    private void configureObject(Object instance) {
        Configurer configurer = (Configurer)this.getBus().getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(instance);
        }
    }

    public String getBeanName() {
        QName endpointName = this.getEndpointName();
        if (endpointName == null) {
            JaxWsImplementorInfo implInfo = new JaxWsImplementorInfo(this.getImplementorClass());
            endpointName = implInfo.getEndpointName();
        }
        return endpointName.toString() + ".jaxws-endpoint";
    }

    public WSDLFilePublisher getWsdlPublisher() {
        return this.wsdlPublisher;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }
}

