/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.InstanceProvider;

public final class CXFInstanceProvider
implements InstanceProvider {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CXFInstanceProvider.class);
    private final ServerFactoryBean factory;
    private final Map<String, Object> cache = new HashMap<String, Object>();

    public CXFInstanceProvider(ServerFactoryBean factory) {
        this.factory = factory;
    }

    public synchronized Object getInstance(String className) {
        Object instance = this.cache.get(className);
        if (instance == null) {
            List chain;
            Object serviceBean = this.factory.getServiceBean();
            if (className.equals(this.factory.getServiceBean().getClass().getName())) {
                instance = serviceBean;
                this.cache.put(className, instance);
            }
            if (instance == null && (chain = ((JaxWsEndpointImpl)this.factory.getServer().getEndpoint()).getJaxwsBinding().getHandlerChain()) != null) {
                for (Handler handler : chain) {
                    if (!className.equals(handler.getClass().getName())) continue;
                    instance = handler;
                    this.cache.put(className, instance);
                }
            }
        }
        if (instance == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_CLASS", (Object[])new Object[]{className}));
        }
        return instance;
    }
}

