/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.security.Principal;
import java.util.Calendar;
import java.util.TimeZone;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.security.SimplePrincipal;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.security.authentication.SecurityActions;
import org.jboss.wsf.stack.cxf.security.authentication.callback.UsernameTokenCallbackHandler;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;

public class SubjectCreator {
    private static final int TIMESTAMP_FRESHNESS_THRESHOLD = 300;
    private boolean propagateContext;
    private int timestampThreshold = 300;
    private NonceStore nonceStore;
    private boolean decodeNonce = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubject(SecurityDomainContext ctx, String name, String password, boolean isDigest, String nonce, String created) {
        if (isDigest) {
            this.verifyUsernameToken(nonce, created);
            UsernameTokenCallbackHandler handler = new UsernameTokenCallbackHandler(nonce, created, this.decodeNonce);
            CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
        }
        SimplePrincipal principal = new SimplePrincipal(name);
        Subject subject = new Subject();
        boolean TRACE = Loggers.SECURITY_LOGGER.isTraceEnabled();
        if (TRACE) {
            Loggers.SECURITY_LOGGER.aboutToAuthenticate(ctx.getSecurityDomain());
        }
        try {
            ClassLoader tccl = SecurityActions.getContextClassLoader();
            SecurityActions.setContextClassLoader((ClassLoader)new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), tccl));
            try {
                if (!ctx.isValid((Principal)principal, (Object)password, subject)) {
                    throw Messages.MESSAGES.authenticationFailed(principal.getName());
                }
            }
            finally {
                SecurityActions.setContextClassLoader(tccl);
            }
        }
        finally {
            if (isDigest) {
                CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
            }
        }
        if (TRACE) {
            Loggers.SECURITY_LOGGER.authenticated(name);
        }
        if (this.propagateContext) {
            ctx.pushSubjectContext(subject, (Principal)principal, (Object)password);
            if (TRACE) {
                Loggers.SECURITY_LOGGER.securityContextPropagated(name);
            }
        }
        return subject;
    }

    private void verifyUsernameToken(String nonce, String created) {
        if (created != null) {
            Calendar cal = SubjectCreator.unmarshalDateTime(created);
            Calendar ref = Calendar.getInstance();
            ref.add(13, -this.timestampThreshold);
            if (ref.after(cal)) {
                throw Messages.MESSAGES.requestRejectedTimeStamp(created);
            }
        }
        if (nonce != null && this.nonceStore != null) {
            if (this.nonceStore.hasNonce(nonce)) {
                throw Messages.MESSAGES.requestRejectedSameNonce(nonce);
            }
            this.nonceStore.putNonce(nonce);
        }
    }

    public void setPropagateContext(boolean propagateContext) {
        this.propagateContext = propagateContext;
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.timestampThreshold = timestampThreshold;
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.nonceStore = nonceStore;
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.decodeNonce = decodeNonce;
    }

    private static Calendar unmarshalDateTime(String value) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int timeInd = SubjectCreator.parseDate(value, 0, cal);
        if (value.charAt(timeInd) != 'T') {
            throw Messages.MESSAGES.invalidDateTimeFormat(value.charAt(timeInd));
        }
        int tzStart = SubjectCreator.parseTime(value, timeInd + 1, cal);
        TimeZone tz = null;
        if (value.length() > tzStart) {
            tz = SubjectCreator.parseTimeZone(value, tzStart);
        }
        if (tz != null) {
            cal.setTimeZone(tz);
        }
        return cal;
    }

    private static int parseDate(String value, int start, Calendar cal) {
        if (value.charAt(start) == '-') {
            ++start;
        }
        if (!Character.isDigit(value.charAt(start))) {
            throw Messages.MESSAGES.invalidDateValueFormat(value);
        }
        int nextToken = value.indexOf(45, start);
        if (nextToken == -1 || nextToken - start < 4) {
            throw Messages.MESSAGES.invalidDateValueFormat(value);
        }
        int year = Integer.parseInt(value.substring(start, nextToken));
        start = nextToken + 1;
        if ((nextToken = value.indexOf(45, start)) == -1 || nextToken - start < 2) {
            throw Messages.MESSAGES.invalidDateValueFormat(value);
        }
        int month = Integer.parseInt(value.substring(start, nextToken));
        start = nextToken + 1;
        int day = Integer.parseInt(value.substring(start, nextToken += 3));
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        return nextToken;
    }

    private static int parseTime(String value, int start, Calendar cal) {
        if (value.charAt(start + 2) != ':' || value.charAt(start + 5) != ':') {
            throw Messages.MESSAGES.invalidTimeValueFormat(value);
        }
        int hh = Integer.parseInt(value.substring(start, start + 2));
        int mm = Integer.parseInt(value.substring(start + 3, start + 5));
        int ss = Integer.parseInt(value.substring(start + 6, start + 8));
        int millis = 0;
        int x = start + 8;
        if (value.length() > x && value.charAt(x) == '.') {
            char c;
            int mul = 100;
            ++x;
            while (x < value.length() && Character.isDigit(c = value.charAt(x))) {
                if (mul != 0) {
                    millis += Character.digit(c, 10) * mul;
                    mul = mul == 1 ? 0 : mul / 10;
                }
                ++x;
            }
        }
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        cal.set(14, millis);
        return x;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TimeZone parseTimeZone(String value, int start) {
        if (value.charAt(start) == '+' || value.charAt(start) == '-') {
            if (value.length() - start != 6) throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
            if (!Character.isDigit(value.charAt(start + 1))) throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
            if (!Character.isDigit(value.charAt(start + 2))) throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
            if (value.charAt(start + 3) != ':') throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
            if (!Character.isDigit(value.charAt(start + 4))) throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
            if (!Character.isDigit(value.charAt(start + 5))) throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
            return TimeZone.getTimeZone("GMT" + value.substring(start));
        }
        if (value.charAt(start) != 'Z') throw Messages.MESSAGES.invalidTimeZoneValueFormat(value.substring(start));
        return TimeZone.getTimeZone("GMT");
    }
}

