/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.transport;

import java.net.URI;
import java.net.URL;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapAddress;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.stack.cxf.Loggers;

public class AddressRewritingEndpointInfo
extends EndpointInfo {
    private ServerConfig serverConfig;
    SoapAddress saddress;

    AddressRewritingEndpointInfo(ServiceInfo serv, String trans, ServerConfig serverConfig) {
        super(serv, trans);
        this.serverConfig = serverConfig;
    }

    public void setAddress(String s) {
        String previousAddress = super.getAddress();
        super.setAddress(s);
        boolean setNewAddress = false;
        if (previousAddress == null) {
            setNewAddress = true;
        } else if (this.isRewriteAllowed(s) && this.isRewriteRequired(s, previousAddress)) {
            String uriScheme = AddressRewritingEndpointInfo.getUriScheme(s);
            if ("https".equalsIgnoreCase(AddressRewritingEndpointInfo.getUriScheme(previousAddress))) {
                uriScheme = "https";
            }
            if (uriScheme == null) {
                uriScheme = "http";
            }
            s = this.rewriteSoapAddress(s, uriScheme);
            setNewAddress = true;
        }
        if (setNewAddress && this.saddress != null) {
            Loggers.ADDRESS_REWRITE_LOGGER.settingNewServiceEndpointAddressInWsdl(s);
            this.saddress.setLocationURI(s);
        }
    }

    public void addExtensor(Object el) {
        super.addExtensor(el);
        if (el instanceof SoapAddress) {
            this.saddress = (SoapAddress)el;
        }
    }

    protected boolean isRewriteAllowed(String address) {
        return address != null && address.trim().toLowerCase().startsWith("http");
    }

    protected boolean isRewriteRequired(String address, String previousAddress) {
        if (address.equals(previousAddress)) {
            return false;
        }
        if (this.serverConfig.isModifySOAPAddress()) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfServerConf(previousAddress);
            return true;
        }
        if (this.isInvalidAddress(previousAddress)) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfInvalidAddress(previousAddress);
            return true;
        }
        Loggers.ADDRESS_REWRITE_LOGGER.rewriteNotRequired(previousAddress);
        return false;
    }

    protected boolean isInvalidAddress(String address) {
        if (address == null) {
            return true;
        }
        String s = address.trim();
        if (s.length() == 0 || s.contains("REPLACE_WITH_ACTUAL_URL")) {
            return true;
        }
        try {
            new URL(s);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    protected String rewriteSoapAddress(String s, String uriScheme) {
        try {
            int portNo;
            URL url = new URL(s);
            String path = url.getPath();
            String host = this.serverConfig.getWebServiceHost();
            String port = "";
            if ("https".equals(uriScheme)) {
                portNo = this.serverConfig.getWebServiceSecurePort();
                if (portNo != 443) {
                    port = ":" + portNo;
                }
            } else {
                portNo = this.serverConfig.getWebServicePort();
                if (portNo != 80) {
                    port = ":" + portNo;
                }
            }
            String urlStr = uriScheme + "://" + host + port + path;
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewritten(s, urlStr);
            return urlStr;
        }
        catch (Exception e) {
            Loggers.ADDRESS_REWRITE_LOGGER.invalidAddressProvidedUseItWithoutRewriting(s);
            return s;
        }
    }

    private static String getUriScheme(String address) {
        try {
            URI addrURI = new URI(address);
            String scheme = addrURI.getScheme();
            return scheme;
        }
        catch (Exception e) {
            return null;
        }
    }
}

