/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;

public class RequestHandlerImpl
implements RequestHandler {
    private static RequestHandlerImpl me;

    RequestHandlerImpl() {
    }

    static synchronized RequestHandlerImpl getInstance() {
        if (me == null) {
            me = new RequestHandlerImpl();
        }
        return me;
    }

    public void handleHttpRequest(Endpoint ep, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        Bus bus = ((BusHolder)ep.getService().getDeployment().getAttachment(BusHolder.class)).getBus();
        AbstractHTTPDestination dest = this.findDestination(req, bus);
        boolean requestHandled = this.handleQuery(req, res, dest, bus);
        if (!requestHandled) {
            Long beginTime = this.initRequestMetrics(ep);
            HttpServletResponseWrapper response = new HttpServletResponseWrapper(res);
            try {
                ServletConfig cfg = (ServletConfig)context.getAttribute(ServletConfig.class.getName());
                dest.invoke(cfg, context, req, (HttpServletResponse)response);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
            if (response.getStatus() < 500) {
                this.processResponseMetrics(ep, beginTime);
            } else {
                this.processFaultMetrics(ep, beginTime);
            }
        }
    }

    public void handleRequest(Endpoint endpoint, InputStream inStream, OutputStream outStream, InvocationContext context) {
        throw new NotImplementedException();
    }

    public void handleWSDLRequest(Endpoint endpoint, OutputStream outStream, InvocationContext context) {
        throw new NotImplementedException();
    }

    private AbstractHTTPDestination findDestination(HttpServletRequest req, Bus bus) throws ServletException {
        String requestURI = req.getRequestURI();
        DestinationRegistry destRegistry = RequestHandlerImpl.getDestinationRegistryFromBus(bus);
        if (destRegistry == null) {
            throw Messages.MESSAGES.cannotObtainRegistry(DestinationRegistry.class.getName());
        }
        Collection destinations = destRegistry.getDestinations();
        AbstractHTTPDestination returnValue = null;
        for (AbstractHTTPDestination destination : destinations) {
            String address;
            EndpointInfo endpointInfo = destination.getEndpointInfo();
            String path = address = endpointInfo.getAddress();
            try {
                path = new URL(address).getPath();
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (path == null) continue;
            if (requestURI.equals(path)) {
                return destination;
            }
            if (!requestURI.startsWith(path)) continue;
            returnValue = destination;
        }
        if (returnValue == null) {
            throw Messages.MESSAGES.cannotObtainDestinationFor(requestURI);
        }
        return returnValue;
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) throws ServletException {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException e) {
            throw Messages.MESSAGES.cannotObtainDestinationFactoryForHttpTransport((Throwable)e);
        }
        return null;
    }

    private final boolean handleQuery(HttpServletRequest req, HttpServletResponse res, AbstractHTTPDestination dest, Bus bus) throws ServletException {
        QueryHandlerRegistry qhr;
        String queryString = req.getQueryString();
        if (null != queryString && queryString.length() > 0 && (qhr = (QueryHandlerRegistry)bus.getExtension(QueryHandlerRegistry.class)) != null) {
            String ctxUri = req.getRequestURI();
            String baseUri = req.getRequestURL().toString() + "?" + queryString;
            EndpointInfo endpointInfo = dest.getEndpointInfo();
            boolean autoRewrite = SoapAddressRewriteHelper.isAutoRewriteOn(AbstractServerConfig.getServerIntegrationServerConfig());
            endpointInfo.setProperty("autoRewriteSoapAddress", (Object)autoRewrite);
            endpointInfo.setProperty("autoRewriteSoapAddressForAllServices", (Object)autoRewrite);
            for (QueryHandler queryHandler : qhr.getHandlers()) {
                if (!queryHandler.isRecognizedQuery(baseUri, ctxUri, endpointInfo)) continue;
                res.setContentType(queryHandler.getResponseContentType(baseUri, ctxUri));
                try {
                    ServletOutputStream out = res.getOutputStream();
                    queryHandler.writeResponse(baseUri, ctxUri, endpointInfo, (OutputStream)out);
                    out.flush();
                    return true;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
        return false;
    }

    private long initRequestMetrics(Endpoint endpoint) {
        long beginTime = 0L;
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            beginTime = metrics.processRequestMessage();
        }
        return beginTime;
    }

    private void processResponseMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processResponseMessage(beginTime);
        }
    }

    private void processFaultMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processFaultMessage(beginTime);
        }
    }
}

