/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.ws.security.WSSConfig;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringConfigurer;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.configuration.ServerBeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.spring.handler.NamespaceHandlerResolver;
import org.jboss.wsf.stack.cxf.spring.parser.JaxwsEndpointDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringBusHolder
extends BusHolder {
    private boolean configured = false;
    protected BusApplicationContext ctx;
    protected List<GenericApplicationContext> additionalCtx = new LinkedList<GenericApplicationContext>();
    private ConfiguredBeanLocator delegatingBeanLocator;
    protected URL jbosswsCxfLocation;
    protected URL[] additionalLocations;

    public SpringBusHolder(URL location, URL jbosswscxf, URL ... additionalLocations) {
        this.createBus(location);
        this.jbosswsCxfLocation = jbosswscxf;
        this.additionalLocations = additionalLocations;
    }

    protected void createBus(URL location) {
        this.bus = new JBossWSSpringBusFactory().createBus((URL[])null);
        ConfiguredBeanLocator delegate = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class);
        this.delegatingBeanLocator = new DelegatingBeanLocator(this.additionalCtx, delegate);
        this.bus.setExtension((Object)this.delegatingBeanLocator, ConfiguredBeanLocator.class);
        this.ctx = (BusApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        if (location != null) {
            try {
                this.loadAdditionalConfig((ApplicationContext)this.ctx, location);
            }
            catch (IOException e) {
                Loggers.DEPLOYMENT_LOGGER.unableToLoadAdditionalConfigurationFrom(location, (Throwable)e);
            }
        }
        this.bus.setExtension((Object)new ServletDestinationFactory(), HttpDestinationFactory.class);
    }

    @Override
    public void configure(ResourceResolver resolver, Configurer configurer, JBossWebservicesMetaData wsmd) {
        if (this.configured) {
            throw Messages.MESSAGES.busAlreadyConfigured((Object)this.ctx);
        }
        super.configure(resolver, configurer, wsmd);
        GenericApplicationContext jbosswsCxfContext = null;
        if (this.jbosswsCxfLocation != null) {
            try {
                jbosswsCxfContext = this.loadAdditionalConfig((ApplicationContext)this.ctx, this.jbosswsCxfLocation);
            }
            catch (IOException e) {
                throw Messages.MESSAGES.unableToLoadConfigurationFrom(this.jbosswsCxfLocation, (Throwable)e);
            }
        }
        if (this.additionalLocations != null && (this.jbosswsCxfLocation == null || jbosswsCxfContext.getBeansOfType(JaxwsEndpointDefinitionParser.JBossWSSpringEndpointImpl.class).isEmpty())) {
            for (URL additionXml : this.additionalLocations) {
                try {
                    this.loadAdditionalConfig((ApplicationContext)(this.jbosswsCxfLocation != null ? jbosswsCxfContext : this.ctx), additionXml);
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.unableToLoadConfigurationFrom(additionXml, (Throwable)e);
                }
            }
        }
        try {
            WSSConfig.getNewInstance();
        }
        catch (Exception e) {
            Loggers.DEPLOYMENT_LOGGER.couldNotInitSecurityEngine();
            Loggers.DEPLOYMENT_LOGGER.errorGettingWSSConfig((Throwable)e);
        }
        this.configured = true;
    }

    @Override
    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher, List<Endpoint> depEndpoints, UnifiedVirtualFile root, String epConfigName, String epConfigFile) {
        ApplicationContext ctx = (ApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        ServerBeanCustomizer customizer = new ServerBeanCustomizer();
        customizer.setBindingCustomization(customization);
        customizer.setWsdlPublisher(wsdlPublisher);
        customizer.setDeploymentEndpoints(depEndpoints);
        customizer.setDeploymentRoot(root);
        customizer.setEpConfigFile(epConfigFile);
        customizer.setEpConfigName(epConfigName);
        Configurer orig = (Configurer)this.bus.getExtension(Configurer.class);
        JBossWSSpringConfigurer serverConfigurer = orig instanceof JBossWSSpringConfigurer ? (JBossWSSpringConfigurer)orig : new JBossWSSpringConfigurer(orig);
        serverConfigurer.setApplicationContext(ctx);
        serverConfigurer.setCustomizer((BeanCustomizer)customizer);
        return serverConfigurer;
    }

    protected GenericApplicationContext loadAdditionalConfig(ApplicationContext parent, URL locationUrl) throws IOException {
        if (locationUrl == null) {
            throw Messages.MESSAGES.unableToLoadAdditionalConfigFromNull();
        }
        InputStream is = locationUrl.openStream();
        GenericApplicationContext childCtx = new GenericApplicationContext(parent);
        this.additionalCtx.add(childCtx);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)childCtx);
        reader.setValidationMode(3);
        reader.setNamespaceHandlerResolver((org.springframework.beans.factory.xml.NamespaceHandlerResolver)new NamespaceHandlerResolver(SecurityActions.getContextClassLoader()));
        reader.loadBeanDefinitions((Resource)new InputStreamResource(is));
        childCtx.refresh();
        return childCtx;
    }

    @Override
    public void close() {
        for (GenericApplicationContext gac : this.additionalCtx) {
            gac.destroy();
        }
        super.close();
    }

    @Override
    protected void setBus(Bus bus) {
        super.setBus(bus);
        this.ctx = (BusApplicationContext)bus.getExtension(BusApplicationContext.class);
    }

    private static class DelegatingBeanLocator
    implements ConfiguredBeanLocator {
        private final ConfiguredBeanLocator delegate;
        private final List<GenericApplicationContext> contexts;

        private DelegatingBeanLocator(List<GenericApplicationContext> contexts, ConfiguredBeanLocator delegate) {
            this.delegate = delegate;
            this.contexts = contexts;
        }

        public List<String> getBeanNamesOfType(Class<?> arg0) {
            return this.delegate.getBeanNamesOfType(arg0);
        }

        public <T> T getBeanOfType(String arg0, Class<T> arg1) {
            for (GenericApplicationContext ctx : this.contexts) {
                if (!ctx.containsBean(arg0)) continue;
                return (T)ctx.getBean(arg0, arg1);
            }
            return (T)this.delegate.getBeanOfType(arg0, arg1);
        }

        public <T> Collection<? extends T> getBeansOfType(Class<T> arg0) {
            return this.delegate.getBeansOfType(arg0);
        }

        public boolean hasBeanOfName(String arg0) {
            return this.delegate.hasBeanOfName(arg0);
        }

        public boolean hasConfiguredPropertyValue(String arg0, String arg1, String arg2) {
            return this.delegate.hasConfiguredPropertyValue(arg0, arg1, arg2);
        }

        public <T> boolean loadBeansOfType(Class<T> arg0, ConfiguredBeanLocator.BeanLoaderListener<T> arg1) {
            return this.delegate.loadBeansOfType(arg0, arg1);
        }
    }
}

