/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.metadata.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jboss.ws.common.IOUtils;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.stack.cxf.metadata.services.DDBean;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;
import org.jboss.wsf.stack.cxf.metadata.services.DDJmsAddressBean;

public class DDBeans {
    private final List<DDEndpoint> endpoints = new ArrayList<DDEndpoint>();
    private final List<DDBean> beans = new LinkedList<DDBean>();
    private final List<DDJmsAddressBean> addressBeans = new LinkedList<DDJmsAddressBean>();
    private File tmpFile;

    public List<DDEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public void addEndpoint(DDEndpoint service) {
        this.endpoints.add(service);
    }

    public void addAddress(DDJmsAddressBean addressBean) {
        this.addressBeans.add(addressBean);
    }

    public List<DDBean> getBeans() {
        return this.beans;
    }

    public void addBean(DDBean bean) {
        this.beans.add(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL createFileURL() {
        this.destroyFileURL();
        try {
            File tmpDir = IOUtils.createTempDirectory();
            this.tmpFile = File.createTempFile("jbossws-cxf", ".xml", tmpDir);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile), "UTF-8");
            try {
                this.writeTo(writer);
            }
            finally {
                ((Writer)writer).close();
            }
            return this.tmpFile.toURI().toURL();
        }
        catch (IOException ex) {
            throw new WSFDeploymentException((Throwable)ex);
        }
    }

    public void destroyFileURL() {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<?xml version = \"1.0\" encoding = \"UTF-8\"?><beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:beans='http://www.springframework.org/schema/beans' xmlns:jaxws='http://cxf.apache.org/jaxws' xmlns:wsa='http://cxf.apache.org/ws/addressing' xmlns:jms='http://cxf.apache.org/transports/jms' xmlns:soap='http://cxf.apache.org/bindings/soap' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://cxf.apache.org/transports/jms http://cxf.apache.org/schemas/configuration/jms.xsd http://cxf.apache.org/bindings/soap http://cxf.apache.org/schemas/configuration/soap.xsd http://cxf.apache.org/jaxws http://cxf.apache.org/schemas/jaxws.xsd'>");
        for (DDEndpoint dDEndpoint : this.endpoints) {
            dDEndpoint.writeTo(writer);
        }
        for (DDBean dDBean : this.beans) {
            dDBean.writeTo(writer);
        }
        for (DDJmsAddressBean dDJmsAddressBean : this.addressBeans) {
            dDJmsAddressBean.writeTo(writer);
        }
        writer.write("</beans>");
    }
}

