/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.ws.common.utils.DelegateClassLoader;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static DelegateClassLoader createDelegateClassLoader(final ClassLoader delegate, final ClassLoader parent) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new DelegateClassLoader(delegate, parent);
        }
        return AccessController.doPrivileged(new PrivilegedAction<DelegateClassLoader>(){

            @Override
            public DelegateClassLoader run() {
                return new DelegateClassLoader(delegate, parent);
            }
        });
    }
}

