/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.soap.SOAPBinding;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.UseAsyncMethod;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInvokerInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageOutInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.staxutils.XMLStreamReaderWrapper;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.discovery.listeners.WSDiscoveryServerListener;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.selector.MaximalAlternativeSelector;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLManagerImpl;
import org.jboss.ws.api.annotation.PolicySets;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.AnnotationsInfo;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.config.SOAPAddressRewriteMetadata;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.JBossWSInvoker;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.FeatureUtils;
import org.jboss.wsf.stack.cxf.client.configuration.InterceptorUtils;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSConfigurerImpl;
import org.jboss.wsf.stack.cxf.client.configuration.PropertyReferenceUtils;
import org.jboss.wsf.stack.cxf.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.configuration.ServerBeanCustomizer;
import org.jboss.wsf.stack.cxf.configuration.SysPropExpandingStreamReader;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicySetsAnnotationListener;
import org.jboss.wsf.stack.cxf.i18n.Loggers;
import org.jboss.wsf.stack.cxf.i18n.Messages;
import org.jboss.wsf.stack.cxf.interceptor.EndpointAssociationInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.GracefulShutdownInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.HandlerConfigInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.NsCtxSelectorStoreInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.WSDLSoapAddressRewriteInterceptor;
import org.jboss.wsf.stack.cxf.management.InstrumentationManagerExtImpl;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreatingPolicyInterceptor;

public class BusHolder {
    private boolean configured = false;
    protected DDBeans metadata;
    protected List<EndpointImpl> endpoints = new LinkedList<EndpointImpl>();
    protected Bus bus;
    protected BusHolderLifeCycleListener busHolderListener;
    protected FactoryBeanListener policySetsListener;

    public BusHolder() {
    }

    public BusHolder(Bus bus) {
        this.setBus(bus);
    }

    public BusHolder(DDBeans metadata) {
        this.metadata = metadata;
        this.bus = new JBossWSBusFactory().createBus();
        this.bus.setExtension((Object)new ServletDestinationFactory(), HttpDestinationFactory.class);
    }

    public void configure(ResourceResolver resolver, Configurer configurer, JBossWebservicesMetaData wsmd, Deployment dep) {
        if (this.configured) {
            throw Messages.MESSAGES.busAlreadyConfigured((Object)this.bus);
        }
        this.bus.setProperty("deployment-bus", (Object)true);
        this.busHolderListener = new BusHolderLifeCycleListener();
        ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this.busHolderListener);
        BusHolder.setWSDLManagerStreamWrapper(this.bus);
        if (configurer != null) {
            this.bus.setExtension((Object)configurer, Configurer.class);
        }
        Map<String, String> props = BusHolder.getProperties(wsmd);
        this.setInterceptors(this.bus, dep, props);
        dep.addAttachment(Bus.class, (Object)this.bus);
        try {
            JASPIAuthenticationProvider jaspiProvider = (JASPIAuthenticationProvider)SPIProvider.getInstance().getSPI(JASPIAuthenticationProvider.class, ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            if (jaspiProvider != null && jaspiProvider.enableServerAuthentication(dep, wsmd)) {
                this.bus.getInInterceptors().add(new SubjectCreatingPolicyInterceptor());
            }
        }
        catch (WSFException e) {
            Loggers.DEPLOYMENT_LOGGER.cannotFindJaspiClasses();
        }
        BusHolder.setResourceResolver(this.bus, resolver);
        if (this.bus.getExtension(PolicyEngine.class) != null) {
            ((PolicyEngine)this.bus.getExtension(PolicyEngine.class)).setAlternativeSelector(BusHolder.getAlternativeSelector(props));
        }
        BusHolder.setCXFManagement(this.bus, props);
        BusHolder.setAdditionalWorkQueues(this.bus, props);
        BusHolder.setWSDiscovery(this.bus, props);
        AnnotationsInfo ai = (AnnotationsInfo)dep.getAttachment(AnnotationsInfo.class);
        if (ai == null || ai.hasAnnotatedClasses(new String[]{PolicySets.class.getName()})) {
            this.policySetsListener = new PolicySetsAnnotationListener(dep.getClassLoader());
            ((FactoryBeanListenerManager)this.bus.getExtension(FactoryBeanListenerManager.class)).addListener(this.policySetsListener);
        }
        this.bus.setProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, (Object)true);
        this.bus.setProperty("org.apache.cxf.ws.addressing.decoupled_fault_support", (Object)true);
        this.bus.setProperty("bus.io.CachedOutputStreamCleaner.Strategy", (Object)"single-timer");
        FeatureUtils.addFeatures((InterceptorProvider)this.bus, (Bus)this.bus, props);
        PropertyReferenceUtils.createPropertyReference(props, (Map)this.bus.getProperties());
        for (DDEndpoint dde : this.metadata.getEndpoints()) {
            EndpointImpl endpoint = new EndpointImpl(this.bus, BusHolder.newInstance(dde.getImplementor(), dep));
            if (dde.getInvoker() != null) {
                endpoint.setInvoker(BusHolder.newInvokerInstance(dde.getInvoker(), dep));
            }
            endpoint.setAddress(dde.getAddress());
            endpoint.setEndpointName(dde.getPortName());
            endpoint.setServiceName(dde.getServiceName());
            endpoint.setWsdlLocation(dde.getWsdlLocation());
            BusHolder.setHandlers(endpoint, dde, dep);
            if (dde.getProperties() != null) {
                HashMap<String, Object> p = new HashMap<String, Object>();
                p.putAll(dde.getProperties());
                endpoint.setProperties(p);
            }
            if (dde.isAddressingEnabled()) {
                WSAddressingFeature addressingFeature = new WSAddressingFeature();
                addressingFeature.setAddressingRequired(dde.isAddressingRequired());
                addressingFeature.setResponses(dde.getAddressingResponses());
                endpoint.getFeatures().add(addressingFeature);
            }
            endpoint.setPublishedEndpointUrl(dde.getPublishedEndpointUrl());
            endpoint.setSOAPAddressRewriteMetadata((SOAPAddressRewriteMetadata)dep.getAttachment(SOAPAddressRewriteMetadata.class));
            endpoint.publish();
            this.endpoints.add(endpoint);
            if (!dde.isMtomEnabled()) continue;
            SOAPBinding binding = (SOAPBinding)endpoint.getBinding();
            binding.setMTOMEnabled(true);
        }
        this.configured = true;
    }

    private static void setHandlers(EndpointImpl endpoint, DDEndpoint dde, Deployment dep) {
        List<String> handlers = dde.getHandlers();
        if (handlers != null && !handlers.isEmpty()) {
            LinkedList<Handler> handlerInstances = new LinkedList<Handler>();
            for (String handler : handlers) {
                handlerInstances.add((Handler)BusHolder.newInstance(handler, dep));
            }
            endpoint.setHandlers(handlerInstances);
        }
    }

    public void close() {
        RMManager rmManager = (RMManager)this.bus.getExtension(RMManager.class);
        if (rmManager != null) {
            rmManager.shutdown();
        }
        for (EndpointImpl endpoint : this.endpoints) {
            if (!endpoint.isPublished()) continue;
            endpoint.stop();
        }
        this.endpoints.clear();
        if (this.busHolderListener == null || !this.busHolderListener.isPreShutdown()) {
            this.bus.shutdown(true);
        }
        this.busHolderListener = null;
        ((FactoryBeanListenerManager)this.bus.getExtension(FactoryBeanListenerManager.class)).removeListener(this.policySetsListener);
        this.policySetsListener = null;
    }

    private static Invoker newInvokerInstance(String className, Deployment dep) {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(dep.getClassLoader());
            Class<JBossWSInvoker> clazz = tccl.loadClass(className);
            AnnotationsInfo ai = (AnnotationsInfo)dep.getAttachment(AnnotationsInfo.class);
            if (ai != null && clazz.isAssignableFrom(JBossWSInvoker.class)) {
                Constructor<?> constr = clazz.getConstructor(Boolean.TYPE);
                Invoker invoker = (Invoker)constr.newInstance(ai.hasAnnotatedClasses(new String[]{UseAsyncMethod.class.getName()}));
                return invoker;
            }
            Invoker invoker = (Invoker)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return invoker;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
    }

    private static Object newInstance(String className, Deployment dep) {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(dep.getClassLoader());
            Class<?> clazz = tccl.loadClass(className);
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
    }

    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher, ArchiveDeployment dep) {
        ServerBeanCustomizer customizer = new ServerBeanCustomizer();
        customizer.setBindingCustomization(customization);
        customizer.setWsdlPublisher(wsdlPublisher);
        customizer.setDeployment(dep);
        return new JBossWSConfigurerImpl((BeanCustomizer)customizer);
    }

    private static Map<String, String> getProperties(JBossWebservicesMetaData wsmd) {
        Map props = wsmd != null ? wsmd.getProperties() : Collections.emptyMap();
        return props;
    }

    protected void setInterceptors(Bus bus, Deployment dep, Map<String, String> props) {
        String p;
        bus.getInInterceptors().add(new EndpointAssociationInterceptor());
        bus.getInInterceptors().add(new NsCtxSelectorStoreInterceptor());
        bus.getInInterceptors().add(new GracefulShutdownInterceptor());
        String string = p = props != null ? props.get("org.jboss.ws.cxf.disableHandlerAuthChecks") : null;
        if (!(p != null && ("true".equalsIgnoreCase(p) || "1".equalsIgnoreCase(p)) || Boolean.getBoolean("org.jboss.ws.cxf.disableHandlerAuthChecks"))) {
            bus.getInInterceptors().add(new HandlerConfigInterceptor());
        } else {
            bus.getInInterceptors().add(new HandlerConfigInterceptor(true));
        }
        SOAPAddressRewriteMetadata sarm = (SOAPAddressRewriteMetadata)dep.getAttachment(SOAPAddressRewriteMetadata.class);
        if (SoapAddressRewriteHelper.isPathRewriteRequired(sarm) || SoapAddressRewriteHelper.isSchemeRewriteRequired(sarm)) {
            bus.getInInterceptors().add(new WSDLSoapAddressRewriteInterceptor(sarm));
        }
        InterceptorUtils.addInterceptors((InterceptorProvider)bus, props);
    }

    protected static void setResourceResolver(Bus bus, ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            ((ResourceManager)bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
    }

    protected static void setAdditionalWorkQueues(Bus bus, Map<String, String> props) {
        if (props != null && !props.isEmpty()) {
            HashMap<String, HashMap<String, String>> queuesMap = new HashMap<String, HashMap<String, String>>();
            for (Map.Entry<String, String> e : props.entrySet()) {
                String sk;
                int i;
                String k = e.getKey();
                if (!k.startsWith("cxf.queue.") || (i = (sk = k.substring("cxf.queue.".length())).indexOf(".")) <= 0) continue;
                String queueName = sk.substring(0, i);
                String queueProp = sk.substring(i + 1);
                HashMap<String, String> m = (HashMap<String, String>)queuesMap.get(queueName);
                if (m == null) {
                    m = new HashMap<String, String>();
                    queuesMap.put(queueName, m);
                }
                m.put(queueProp, e.getValue());
            }
            WorkQueueManager mgr = (WorkQueueManager)bus.getExtension(WorkQueueManager.class);
            for (Map.Entry e : queuesMap.entrySet()) {
                String queueName = (String)e.getKey();
                AutomaticWorkQueue q = BusHolder.createWorkQueue(queueName, (Map)e.getValue());
                mgr.addNamedWorkQueue(queueName, q);
            }
        }
    }

    protected static void setCXFManagement(Bus bus, Map<String, String> props) {
        String p;
        if (props != null && !props.isEmpty() && ("true".equalsIgnoreCase(p = props.get("cxf.management.enabled")) || "1".equalsIgnoreCase(p))) {
            InstrumentationManagerExtImpl instrumentationManagerImpl = new InstrumentationManagerExtImpl();
            instrumentationManagerImpl.setBus(bus);
            instrumentationManagerImpl.setEnabled(true);
            instrumentationManagerImpl.init();
            instrumentationManagerImpl.initMBeanServer();
            bus.setExtension((Object)instrumentationManagerImpl, InstrumentationManager.class);
            CounterRepository couterRepository = new CounterRepository();
            couterRepository.setBus(bus);
            String installRespTimeInterceptors = props.get("cxf.management.installResponseTimeInterceptors");
            if (installRespTimeInterceptors == null || "true".equalsIgnoreCase(installRespTimeInterceptors) || "1".equalsIgnoreCase(installRespTimeInterceptors)) {
                ResponseTimeMessageInInterceptor in = new ResponseTimeMessageInInterceptor();
                ResponseTimeMessageInvokerInterceptor invoker = new ResponseTimeMessageInvokerInterceptor();
                ResponseTimeMessageOutInterceptor out = new ResponseTimeMessageOutInterceptor();
                bus.getInInterceptors().add(in);
                bus.getInInterceptors().add(invoker);
                bus.getOutInterceptors().add(out);
            }
            bus.setExtension((Object)couterRepository, CounterRepository.class);
        }
    }

    protected static void setWSDiscovery(Bus bus, Map<String, String> props) {
        String p;
        if (props != null && !props.isEmpty() && ("true".equalsIgnoreCase(p = props.get("cxf.ws-discovery.enabled")) || "1".equalsIgnoreCase(p))) {
            ((ServerLifeCycleManager)bus.getExtension(ServerLifeCycleManager.class)).registerListener((ServerLifeCycleListener)new WSDiscoveryServerListener(bus));
        }
    }

    private static void setWSDLManagerStreamWrapper(Bus bus) {
        ((WSDLManagerImpl)bus.getExtension(WSDLManager.class)).setXMLStreamReaderWrapper(new XMLStreamReaderWrapper(){

            public XMLStreamReader wrap(XMLStreamReader reader) {
                return new SysPropExpandingStreamReader(reader);
            }
        });
    }

    private static AlternativeSelector getAlternativeSelector(Map<String, String> props) {
        String className;
        MaximalAlternativeSelector selector = new MaximalAlternativeSelector();
        if (props != null && !props.isEmpty() && (className = props.get("cxf.policy.alternativeSelector")) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                selector = (AlternativeSelector)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return selector;
    }

    private static AutomaticWorkQueue createWorkQueue(String name, Map<String, String> props) {
        int mqs = BusHolder.parseInt(props.get("maxQueueSize"), 256);
        int initialThreads = BusHolder.parseInt(props.get("initialThreads"), 0);
        int highWaterMark = BusHolder.parseInt(props.get("highWaterMark"), 25);
        int lowWaterMark = BusHolder.parseInt(props.get("lowWaterMark"), 5);
        long dequeueTimeout = BusHolder.parseLong(props.get("dequeueTimeout"), 120000L);
        return new AutomaticWorkQueueImpl(mqs, initialThreads, highWaterMark, lowWaterMark, dequeueTimeout, name);
    }

    private static int parseInt(String prop, int defaultValue) {
        return prop != null ? Integer.parseInt(prop) : defaultValue;
    }

    private static long parseLong(String prop, long defaultValue) {
        return prop != null ? Long.parseLong(prop) : defaultValue;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected void setBus(Bus bus) {
        this.bus = bus;
    }

    private static class BusHolderLifeCycleListener
    implements BusLifeCycleListener {
        private volatile boolean preShutdown = false;

        private BusHolderLifeCycleListener() {
        }

        public boolean isPreShutdown() {
            return this.preShutdown;
        }

        public void initComplete() {
        }

        public void preShutdown() {
            this.preShutdown = true;
        }

        public void postShutdown() {
        }
    }
}

