/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServerConnection;
import javax.naming.NamingException;
import javax.security.sasl.SaslException;
import junit.extensions.TestSetup;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.wsf.test.CleanupOperation;
import org.jboss.wsf.test.JBossWSTestHelper;

public class JBossWSTestSetup
extends TestSetup {
    private static Logger log = Logger.getLogger(JBossWSTestSetup.class);
    private static final String JBOSSWS_SEC_DOMAIN = "JBossWS";
    private static final String SYSPROP_HTTPS_CONNECTION_REUSE_TIMEOUT = "test.https.connection.reuse.timeout";
    private static final int HTTPS_CONNECTION_REUSE_TIMEOUT = Integer.getInteger("test.https.connection.reuse.timeout", 5000);
    private String[] archives = new String[0];
    private OutputStream appclientOutputStream;
    private String appclientArg;
    private ClassLoader originalClassLoader;
    private Map<String, Map<String, String>> securityDomains;
    private boolean defaultSecurityDomainRequirement = false;
    private Map<String, String> httpsConnOptions;
    private CleanupOperation cleanupOp;
    private static volatile AtomicLong lastHttpsConnectorRemoval = new AtomicLong(0L);

    public JBossWSTestSetup(Class<?> testClass, String archiveList) {
        super((Test)new TestSuite(testClass));
        this.getArchiveArray(archiveList);
    }

    public JBossWSTestSetup(Class<?> testClass, String archiveList, CleanupOperation cleanupOp) {
        this(testClass, archiveList);
        this.cleanupOp = cleanupOp;
    }

    public JBossWSTestSetup(Class<?> testClass, String archiveList, OutputStream appclientOutputStream) {
        super((Test)new TestSuite(testClass));
        this.getArchiveArray(archiveList);
        this.appclientOutputStream = appclientOutputStream;
    }

    public JBossWSTestSetup(Class<?> testClass, String archiveList, boolean requiresDefaultSecurityDomain) {
        this(testClass, archiveList);
        this.setDefaultSecurityDomainRequirement(requiresDefaultSecurityDomain);
    }

    public JBossWSTestSetup(Class<?> testClass, String archiveList, boolean requiresDefaultSecurityDomain, CleanupOperation cleanupOp) {
        this(testClass, archiveList, requiresDefaultSecurityDomain);
        this.cleanupOp = cleanupOp;
    }

    public JBossWSTestSetup(Test test, String archiveList) {
        super(test);
        this.getArchiveArray(archiveList);
    }

    public JBossWSTestSetup(Test test, String archiveList, CleanupOperation cleanupOp) {
        this(test, archiveList);
        this.cleanupOp = cleanupOp;
    }

    public JBossWSTestSetup(Test test, String archiveList, boolean requiresDefaultSecurityDomain) {
        this(test, archiveList);
        this.setDefaultSecurityDomainRequirement(requiresDefaultSecurityDomain);
    }

    public JBossWSTestSetup(Test test) {
        super(test);
    }

    public void run(final TestResult result) {
        Protectable p = new Protectable(){

            public void protect() throws Exception {
                JBossWSTestSetup.this.setUp();
                JBossWSTestSetup.this.basicRun(result);
                if (JBossWSTestSetup.this.cleanupOp != null) {
                    JBossWSTestSetup.this.cleanupOp.cleanUp();
                }
                JBossWSTestSetup.this.tearDown();
            }
        };
        result.runProtected((Test)this, p);
    }

    public File getArchiveFile(String archive) {
        return JBossWSTestHelper.getArchiveFile(archive);
    }

    public URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
    }

    public File getResourceFile(String resource) {
        return JBossWSTestHelper.getResourceFile(resource);
    }

    public URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURI().toURL();
    }

    private void getArchiveArray(String archiveList) {
        if (archiveList != null) {
            StringTokenizer st = new StringTokenizer(archiveList, ", ");
            this.archives = new String[st.countTokens()];
            for (int i = 0; i < this.archives.length; ++i) {
                this.archives[i] = st.nextToken();
            }
        }
    }

    protected void setUp() throws Exception {
        long wait;
        long lr;
        ClassLoader parent;
        String integrationTarget = JBossWSTestHelper.getIntegrationTarget();
        log.debug((Object)("Integration target: " + integrationTarget));
        if (this.securityDomains != null && !this.securityDomains.isEmpty()) {
            for (String key : this.securityDomains.keySet()) {
                JBossWSTestHelper.addSecurityDomain(key, this.securityDomains.get(key));
            }
        }
        if (this.defaultSecurityDomainRequirement) {
            String usersPropFile = System.getProperty("org.jboss.ws.testsuite.securityDomain.users.propfile");
            String rolesPropFile = System.getProperty("org.jboss.ws.testsuite.securityDomain.roles.propfile");
            HashMap<String, String> authenticationOptions = new HashMap<String, String>();
            if (usersPropFile != null) {
                authenticationOptions.put("usersProperties", usersPropFile);
            }
            if (rolesPropFile != null) {
                authenticationOptions.put("rolesProperties", rolesPropFile);
            }
            authenticationOptions.put("unauthenticatedIdentity", "anonymous");
            try {
                JBossWSTestHelper.addSecurityDomain(JBOSSWS_SEC_DOMAIN, authenticationOptions);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn((Object)"Could not add default security domain!", (Throwable)e);
            }
        }
        if (this.httpsConnOptions != null) {
            JBossWSTestHelper.addHttpsConnector(this.httpsConnOptions);
        }
        ArrayList<URL> clientJars = new ArrayList<URL>();
        for (int i = 0; i < this.archives.length; ++i) {
            URL archiveURL;
            String archive = this.archives[i];
            if (archive.endsWith("-appclient.jar")) {
                archiveURL = this.getArchiveURL(archive.substring(archive.indexOf(35) + 1));
                clientJars.add(archiveURL);
                JBossWSTestHelper.deployAppclient(archive, this.appclientOutputStream, this.appclientArg);
                continue;
            }
            if (archive.endsWith("-client.jar")) {
                archiveURL = this.getArchiveURL(archive);
                clientJars.add(archiveURL);
                continue;
            }
            JBossWSTestSetup.performDeploy(archive);
        }
        this.originalClassLoader = parent = Thread.currentThread().getContextClassLoader();
        if (!clientJars.isEmpty()) {
            URL[] urls = new URL[clientJars.size()];
            for (int i = 0; i < clientJars.size(); ++i) {
                urls[i] = (URL)clientJars.get(i);
            }
            URLClassLoader cl = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (this.httpsConnOptions != null && (lr = lastHttpsConnectorRemoval.get()) != 0L && (wait = (long)HTTPS_CONNECTION_REUSE_TIMEOUT - (System.currentTimeMillis() - lr)) > 0L) {
            log.info((Object)("Will sleep for " + wait + " ms..."));
            Thread.sleep(wait);
            log.debug((Object)"Going on!");
        }
    }

    private static void performDeploy(String archive) throws Exception {
        try {
            JBossWSTestHelper.deploy(archive);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            boolean foundSecurityCause = false;
            for (Throwable cause = ex.getCause(); !foundSecurityCause && cause != null && cause != ex; cause = cause.getCause()) {
                foundSecurityCause = cause instanceof SaslException;
                ex = cause;
            }
            if (foundSecurityCause) {
                System.out.println("\n** Please make sure you properly setup authentication credentials to the application server management console **\n\nIn order for running the JBossWS testsuite against a protected application server (username/password different from 'admin' / 'admin'),\nuse '-Djbossws.deployer.authentication.username=username -Djbossws.deployer.authentication.password=password'\n");
            }
            JBossWSTestHelper.undeploy(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            for (int i = 0; i < this.archives.length; ++i) {
                String archive = this.archives[this.archives.length - i - 1];
                if (archive.endsWith("-appclient.jar")) {
                    JBossWSTestHelper.undeployAppclient(archive, true);
                    continue;
                }
                if (archive.endsWith("-client.jar")) continue;
                JBossWSTestHelper.undeploy(archive);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
            if (this.securityDomains != null && !this.securityDomains.isEmpty()) {
                for (String key : this.securityDomains.keySet()) {
                    JBossWSTestHelper.removeSecurityDomain(key);
                }
            }
            if (this.defaultSecurityDomainRequirement) {
                JBossWSTestHelper.removeSecurityDomain(JBOSSWS_SEC_DOMAIN);
            }
            if (this.httpsConnOptions != null) {
                JBossWSTestHelper.removeHttpsConnector();
                lastHttpsConnectorRemoval.set(System.currentTimeMillis());
            }
        }
    }

    protected ClassLoader getOriginalClassLoader() {
        return this.originalClassLoader;
    }

    public MBeanServerConnection getServer() throws NamingException {
        return JBossWSTestHelper.getServer();
    }

    public void addSecurityDomainRequirement(String securityDomainName, Map<String, String> authenticationOptions) {
        if (this.securityDomains == null) {
            this.securityDomains = new HashMap<String, Map<String, String>>();
        }
        this.securityDomains.put(securityDomainName, authenticationOptions);
    }

    public void setDefaultSecurityDomainRequirement(boolean defaultSecurityDomainRequirement) {
        this.defaultSecurityDomainRequirement = defaultSecurityDomainRequirement;
    }

    public void setHttpsConnectorRequirement(Map<String, String> options) {
        this.httpsConnOptions = options;
    }
}

