/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import junit.framework.Test;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.jboss.logging.Logger;
import org.jboss.wsf.test.CleanupOperation;
import org.jboss.wsf.test.JBossWSTestSetup;

public class JBossWSCXFTestSetup
extends JBossWSTestSetup {
    private Bus defaultBus;

    public JBossWSCXFTestSetup(Class<?> testClass, String archiveList) {
        super(testClass, archiveList);
    }

    public JBossWSCXFTestSetup(Class<?> testClass, String archiveList, boolean requiresDefaultSecurityDomain) {
        super(testClass, archiveList, requiresDefaultSecurityDomain);
    }

    public JBossWSCXFTestSetup(Test test, String archiveList) {
        super(test, archiveList);
    }

    public JBossWSCXFTestSetup(Test test, String archiveList, boolean requiresDefaultSecurityDomain) {
        super(test, archiveList, requiresDefaultSecurityDomain);
    }

    public JBossWSCXFTestSetup(Class<?> testClass, String archiveList, boolean requiresDefaultSecurityDomain, CleanupOperation cleanupOp) {
        super(testClass, archiveList, requiresDefaultSecurityDomain, cleanupOp);
    }

    public JBossWSCXFTestSetup(Test test) {
        super(test);
    }

    @Override
    protected void setUp() throws Exception {
        this.defaultBus = BusFactory.getDefaultBus((boolean)false);
        super.setUp();
        Bus threadBus = BusFactory.getThreadDefaultBus((boolean)false);
        if (threadBus != null) {
            ClassLoader busLoader = (ClassLoader)threadBus.getExtension(ClassLoader.class);
            ClassLoader origLoader = this.getOriginalClassLoader();
            if (busLoader != null && busLoader == origLoader) {
                threadBus.setExtension((Object)Thread.currentThread().getContextClassLoader(), ClassLoader.class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        Bus threadBus = BusFactory.getThreadDefaultBus((boolean)false);
        if (threadBus != null) {
            ClassLoader busLoader = (ClassLoader)threadBus.getExtension(ClassLoader.class);
            ClassLoader origLoader = this.getOriginalClassLoader();
            if (busLoader != null && busLoader == Thread.currentThread().getContextClassLoader()) {
                threadBus.setExtension((Object)origLoader, ClassLoader.class);
            }
        }
        try {
            Bus afterTestsDefaultBus = BusFactory.getDefaultBus((boolean)false);
            if (this.defaultBus == null && afterTestsDefaultBus != null) {
                Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Default CXF bus has been set during test execution");
            } else if (this.defaultBus != afterTestsDefaultBus) {
                throw new Exception("CXF Default bus changed during test: \nBEFORE: " + this.defaultBus + "\nAFTER: " + afterTestsDefaultBus);
            }
        }
        finally {
            this.defaultBus = null;
            super.tearDown();
        }
    }
}

