/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployer.Deployer;
import org.jboss.wsf.test.AppclientHelper;

public class JBossWSTestHelper {
    private static final String SYSPROP_JBOSSWS_INTEGRATION_TARGET = "jbossws.integration.target";
    private static final String SYSPROP_JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final String SYSPROP_AS_SERVER_CONN_RETRIEVAL_ATTEMPTS = "test.as.server.connection.retrieval.attempts";
    private static final String TEST_USERNAME = "test.username";
    private static final String TEST_PASSWORD = "test.password";
    private static final boolean DEPLOY_PROCESS_ENABLED = !Boolean.getBoolean("disable.test.archive.deployment");
    private static final int AS_SERVER_CONN_RETRIEVAL_ATTEMPTS = Integer.getInteger("test.as.server.connection.retrieval.attempts", 5);
    private static final String testArchiveDir = System.getProperty("test.archive.directory");
    private static final String testResourcesDir = System.getProperty("test.resources.directory");
    private static final String integrationTarget = System.getProperty("jbossws.integration.target");
    private static final String implInfo;
    private static volatile Deployer deployer;
    private static volatile MBeanServerConnection server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Deployer getDeployer() {
        if (deployer != null) return deployer;
        Class<JBossWSTestHelper> clazz = JBossWSTestHelper.class;
        synchronized (JBossWSTestHelper.class) {
            if (deployer != null) return deployer;
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            deployer = (Deployer)spiProvider.getSPI(Deployer.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return deployer;
        }
    }

    public static void deploy(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
            JBossWSTestHelper.getDeployer().deploy(archiveURL);
        }
    }

    public static void undeploy(String archive) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
            JBossWSTestHelper.getDeployer().undeploy(archiveURL);
        }
    }

    public static Process deployAppclient(String archive, OutputStream appclientOS, String ... appclientArgs) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            return AppclientHelper.deployAppclient(archive, appclientOS, appclientArgs);
        }
        return null;
    }

    public static void undeployAppclient(String archive, boolean awaitShutdown) throws Exception {
        if (DEPLOY_PROCESS_ENABLED) {
            AppclientHelper.undeployAppclient(archive, awaitShutdown);
        }
    }

    public static boolean isTargetWildFly8() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("wildfly8");
    }

    public static boolean isTargetWildFly80() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("wildfly80");
    }

    public static boolean isTargetWildFly9() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("wildfly9");
    }

    public static boolean isIntegrationCXF() {
        String vendor = JBossWSTestHelper.getImplementationInfo();
        return vendor.toLowerCase().indexOf("apache") != -1;
    }

    private static String getImplementationInfo() {
        return implInfo;
    }

    private static Object getImplementationObject() {
        Service service = Service.create((QName)new QName("dummyService"));
        HandlerResolver obj = service.getHandlerResolver();
        if (obj == null) {
            service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
            obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
        }
        return obj;
    }

    public static String getServerHost() {
        String host = System.getProperty(SYSPROP_JBOSS_BIND_ADDRESS, "localhost");
        return JBossWSTestHelper.toIPv6URLFormat(host);
    }

    private static String toIPv6URLFormat(String host) {
        try {
            boolean isIPv6Address;
            if (host.startsWith("[") || host.startsWith(":")) {
                if (System.getProperty("java.net.preferIPv4Stack") == null) {
                    throw new IllegalStateException("always provide java.net.preferIPv4Stack JVM property when using IPv6 address format");
                }
                if (System.getProperty("java.net.preferIPv6Addresses") == null) {
                    throw new IllegalStateException("always provide java.net.preferIPv6Addresses JVM property when using IPv6 address format");
                }
            }
            boolean isIPv6Formatted = (isIPv6Address = InetAddress.getByName(host) instanceof Inet6Address) && host.startsWith("[");
            return isIPv6Address && !isIPv6Formatted ? "[" + host + "]" : host;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MBeanServerConnection getServer() {
        if (server != null) return server;
        Class<JBossWSTestHelper> clazz = JBossWSTestHelper.class;
        synchronized (JBossWSTestHelper.class) {
            if (server != null) return server;
            String integrationTarget = JBossWSTestHelper.getIntegrationTarget();
            if (!integrationTarget.startsWith("wildfly")) throw new IllegalStateException("Unsupported target container: " + integrationTarget);
            server = JBossWSTestHelper.getServerConnection("service:jmx:http-remoting-jmx://" + JBossWSTestHelper.getServerHost() + ":" + 9990);
            // ** MonitorExit[var0] (shouldn't be in output)
            return server;
        }
    }

    private static MBeanServerConnection getServerConnection(String jmxServiceUrl) {
        String urlString = System.getProperty("jmx.service.url", jmxServiceUrl);
        JMXServiceURL serviceURL = null;
        JMXConnector connector = null;
        try {
            serviceURL = new JMXServiceURL(urlString);
        }
        catch (MalformedURLException e1) {
            throw new IllegalStateException(e1);
        }
        for (int i = 0; i < AS_SERVER_CONN_RETRIEVAL_ATTEMPTS && connector == null; ++i) {
            try {
                connector = JMXConnectorFactory.connect(serviceURL, null);
                continue;
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("WAITING") && i < AS_SERVER_CONN_RETRIEVAL_ATTEMPTS - 1) continue;
                throw e;
            }
        }
        try {
            return connector.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, e);
        }
    }

    public static String getIntegrationTarget() {
        return integrationTarget;
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
    }

    public static File getArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURI().toURL();
    }

    public static File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestResourcesDir() == null ? " System property 'test.resources.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestResourcesDir() + "/" + resource + "'." + notSet);
    }

    public static String getTestArchiveDir() {
        return testArchiveDir;
    }

    public static String getTestResourcesDir() {
        return testResourcesDir;
    }

    public static String getTestUsername() {
        String prop = System.getProperty(TEST_USERNAME);
        if (prop == null || "".equals(prop) || "${test.username}".equals(prop)) {
            prop = "kermit";
        }
        return prop;
    }

    public static String getTestPassword() {
        String prop = System.getProperty(TEST_PASSWORD);
        if (prop == null || "".equals(prop) || "${test.password}".equals(prop)) {
            prop = "thefrog";
        }
        return prop;
    }

    public static void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        JBossWSTestHelper.getDeployer().addSecurityDomain(name, authenticationOptions);
    }

    public static void addJaspiSecurityDomain(String name, String loginModuleStackName, Map<String, String> loginModuleOptions, String authModuleName, Map<String, String> authModuleOptions) throws Exception {
        JBossWSTestHelper.getDeployer().addJaspiSecurityDomain(name, loginModuleStackName, loginModuleOptions, authModuleName, authModuleOptions);
    }

    public static void removeSecurityDomain(String name) throws Exception {
        JBossWSTestHelper.getDeployer().removeSecurityDomain(name);
    }

    public static void addHttpsConnector(Map<String, String> options) throws Exception {
        JBossWSTestHelper.getDeployer().addHttpsConnector(options);
    }

    public static void removeHttpsConnector() throws Exception {
        JBossWSTestHelper.getDeployer().removeHttpsConnector();
    }

    public static String setSystemProperty(String propName, String propValue) throws Exception {
        return JBossWSTestHelper.getDeployer().setSystemProperty(propName, propValue);
    }

    public static void restartServer() throws Exception {
        JBossWSTestHelper.getDeployer().restart();
    }

    public static String writeToFile(BaseDeployment<?> ... deps) {
        if (deps == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (BaseDeployment<?> dep : deps) {
            sb.append(dep.writeToFile().getName());
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    static {
        if (integrationTarget == null) {
            throw new IllegalStateException("Cannot obtain system property: jbossws.integration.target");
        }
        Object obj = JBossWSTestHelper.getImplementationObject();
        implInfo = obj.getClass().getPackage().getName();
    }

    public static abstract class JarDeployment
    extends BaseDeployment<JavaArchive> {
        public JarDeployment(String name) {
            super(JavaArchive.class, name);
        }
    }

    public static abstract class WarDeployment
    extends BaseDeployment<WebArchive> {
        public WarDeployment(String name) {
            super(WebArchive.class, name);
        }
    }

    public static abstract class BaseDeployment<T extends Archive<T>> {
        protected T archive;

        public BaseDeployment(Class<T> clazz, String name) {
            this.archive = (Archive)ShrinkWrap.create(clazz, (String)name);
        }

        public T create() {
            return this.archive;
        }

        public T writeToFile() {
            File archiveDir = this.assertArchiveDirExists(JBossWSTestHelper.getTestArchiveDir());
            File file = new File(archiveDir, this.archive.getName());
            ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(file, true);
            return this.archive;
        }

        public String getName() {
            return this.archive.getName();
        }

        private File assertArchiveDirExists(String testArchiveDir) {
            File archiveDir = new File(testArchiveDir);
            if (!archiveDir.exists()) {
                if (testArchiveDir == null) {
                    throw new IllegalArgumentException("Cannot create archive - system property 'test.archive.directory' not set.");
                }
                if (!archiveDir.mkdirs()) {
                    throw new IllegalArgumentException("Cannot create archive - can not create test archive directory '" + archiveDir.getAbsolutePath() + "' not set.");
                }
            }
            return archiveDir;
        }
    }
}

