/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.util.Arrays;
import org.jboss.wsf.test.JBossWSTestHelper;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IgnoreContainer
implements TestRule {
    private String[] ignoredContainers;

    public IgnoreContainer(String ... containers) {
        this.ignoredContainers = containers;
    }

    public Statement apply(Statement base, final Description description) {
        return new Statement(){
            boolean ignored = false;

            public void evaluate() throws Throwable {
                for (String container : IgnoreContainer.this.ignoredContainers) {
                    if (!JBossWSTestHelper.getIntegrationTarget().startsWith(container)) continue;
                    this.ignored = true;
                    break;
                }
                Assume.assumeFalse((String)(description.getClassName() + " is excluded for container: " + Arrays.toString(IgnoreContainer.this.ignoredContainers)), (boolean)this.ignored);
            }
        };
    }
}

