/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IgnoreEnv
implements TestRule {
    public static final IgnoreEnv IPV6 = new IgnoreEnv("java.net.preferIPv6Addresses", "true");
    public static final IgnoreEnv IPV4 = new IgnoreEnv("java.net.preferIPv4Stack", "true");
    private String key;
    private String value;

    public IgnoreEnv(String key) {
        this(key, null);
    }

    public IgnoreEnv(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public Statement apply(Statement base, final Description description) {
        return new Statement(){
            boolean ignored = false;

            public void evaluate() throws Throwable {
                if (IgnoreEnv.this.value != null) {
                    if (System.getProperty(IgnoreEnv.this.key) != null && IgnoreEnv.this.value.equals(System.getProperty(IgnoreEnv.this.key))) {
                        this.ignored = true;
                    }
                } else if (System.getProperty(IgnoreEnv.this.key) != null) {
                    this.ignored = true;
                }
                Assume.assumeFalse((String)(description.getClassName() + " is excluded for system env (" + IgnoreEnv.this.key + ")"), (boolean)this.ignored);
            }
        };
    }
}

