package org.jboss.wsf.test;

import java.util.Properties;

import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;

public class EJBClientConfigurationUtil {
	   public static void createEJBClientConfiguration(String groupQualifier, String containerQualifier)
	   {
	      final Properties config = new Properties();
	      config.put("remote.connections", "default");
	      config.put("remote.connection.default.connect.options.org.xnio.Options.SASL_POLICY_NOANONYMOUS", "false");
	      config.put("remote.connection.default.host", JBossWSTestHelper.getServerHost());
	      config.put("remote.connection.default.port", String.valueOf(JBossWSTestHelper.getServerPort(groupQualifier, containerQualifier)));

	      final EJBClientConfiguration ejbClientConfiguration = new PropertiesBasedEJBClientConfiguration(config);
	      final ConfigBasedEJBClientContextSelector selector = new ConfigBasedEJBClientContextSelector(
	            ejbClientConfiguration);
	      EJBClientContext.setSelector(selector);
	   }
}
