/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ws.common.concurrent.CopyJob;
import org.jboss.ws.common.io.TeeOutputStream;
import org.jboss.wsf.test.JBossWSTestHelper;

final class AppclientHelper {
    private static final String JBOSS_HOME = System.getProperty("jboss.home");
    private static final String FS = System.getProperty("file.separator");
    private static final String PS = System.getProperty("path.separator");
    private static final int TIMEOUT = Integer.getInteger("appclient.timeout", 120);
    private static final String EXT = ":".equals(PS) ? ".sh" : ".bat";
    private static final String appclientScript = JBOSS_HOME + FS + "bin" + FS + "appclient" + EXT;
    private static final Semaphore s = new Semaphore(1, true);
    private static Map<String, AppclientProcess> appclients = Collections.synchronizedMap(new HashMap(2));
    private static ExecutorService executors = Executors.newCachedThreadPool(AppclientDaemonFactory.INSTANCE);
    private static String appclientOutputDir;

    private AppclientHelper() {
    }

    static Process deployAppclient(String archive, OutputStream appclientOS, String ... appclientArgs) throws Exception {
        AppclientProcess ap = AppclientHelper.newAppclientProcess(archive, appclientOS, appclientArgs);
        String patternToMatch = "Deployed \"" + AppclientHelper.getAppclientEarName(archive) + "\"";
        if (!AppclientHelper.awaitOutput(ap.output, patternToMatch)) {
            throw new RuntimeException("Cannot deploy " + AppclientHelper.getAppclientFullName(archive) + " to appclient");
        }
        appclients.put(archive, ap);
        return ap.process;
    }

    static void undeployAppclient(String archive, boolean awaitShutdown) throws Exception {
        AppclientProcess ap = appclients.remove(archive);
        try {
            if (awaitShutdown) {
                AppclientHelper.shutdownAppclient(archive, ap.output);
            }
        }
        finally {
            s.release();
            if (ap != null) {
                if (ap.output != null) {
                    ap.outTask.kill();
                }
                if (ap.errTask != null) {
                    ap.errTask.kill();
                }
                if (ap.process != null) {
                    ap.process.destroy();
                }
                if (ap.log != null) {
                    ap.log.close();
                }
            }
        }
    }

    private static AppclientProcess newAppclientProcess(String archive, OutputStream appclientOS, String ... appclientArgs) throws Exception {
        s.acquire();
        try {
            String killFileName = AppclientHelper.getKillFileName(archive);
            String appclientFullName = AppclientHelper.getAppclientFullName(archive);
            String appclientShortName = AppclientHelper.getAppclientShortName(archive);
            AppclientProcess ap = new AppclientProcess();
            ap.output = new ByteArrayOutputStream();
            LinkedList<String> args = new LinkedList<String>();
            args.add(appclientScript);
            String appclientConfigName = System.getProperty("APPCLIENT_CONFIG_NAME", "appclient.xml");
            String configArg = "--appclient-config=" + appclientConfigName;
            args.add(configArg);
            args.add(appclientFullName);
            if (appclientOS == null) {
                args.add(killFileName);
            } else {
                for (String appclientArg : appclientArgs) {
                    args.add(appclientArg);
                }
            }
            ap.log = new FileOutputStream(new File(AppclientHelper.getAppclientOutputDir(), appclientShortName + ".log-" + System.currentTimeMillis()));
            OutputStream logOutputStreams = appclientOS == null ? ap.log : new TeeOutputStream(ap.log, appclientOS, new OutputStream[0]);
            AppclientHelper.printLogTrailer(logOutputStreams, appclientFullName);
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(args);
            StringBuilder javaOptsValue = new StringBuilder();
            String additionalJVMArgs = System.getProperty("additionalJvmArgs");
            if (additionalJVMArgs != null) {
                javaOptsValue.append(additionalJVMArgs).append(" ");
            } else {
                javaOptsValue.append("-Djava.net.preferIPv4Stack=").append(System.getProperty("java.net.preferIPv4Stack", "true")).append(" ");
                javaOptsValue.append("-Djava.net.preferIPv6Addresses=").append(System.getProperty("java.net.preferIPv6Addresses", "false")).append(" ");
            }
            javaOptsValue.append("-Djboss.bind.address=").append(AppclientHelper.undoIPv6Brackets(System.getProperty("jboss.bind.address", "localhost"))).append(" ");
            String appclientDebugOpts = System.getProperty("APPCLIENT_DEBUG_OPTS", null);
            if (appclientDebugOpts != null && appclientDebugOpts.trim().length() > 0) {
                javaOptsValue.append(appclientDebugOpts).append(" ");
            }
            pb.environment().put("JAVA_OPTS", javaOptsValue.toString());
            System.out.println("JAVA_OPTS=\"" + javaOptsValue.toString() + "\"");
            System.out.println("Starting " + appclientScript + " " + configArg + " " + appclientFullName + (appclientArgs == null ? "" : " with args " + Arrays.asList(appclientArgs)));
            ap.process = pb.start();
            ap.outTask = new CopyJob(ap.process.getInputStream(), (OutputStream)new TeeOutputStream(ap.output, logOutputStreams, new OutputStream[0]));
            ap.errTask = new CopyJob(ap.process.getErrorStream(), ap.log);
            executors.submit((Runnable)ap.outTask);
            executors.submit((Runnable)ap.errTask);
            return ap;
        }
        catch (Exception e) {
            s.release();
            throw e;
        }
    }

    private static void printLogTrailer(OutputStream logOutputStreams, String appclientFullName) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(logOutputStreams, StandardCharsets.UTF_8));
        pw.write("Starting appclient process: " + appclientFullName + "...\n");
        pw.flush();
    }

    private static String undoIPv6Brackets(String s) {
        return s.startsWith("[") ? s.substring(1, s.length() - 1) : s;
    }

    private static void shutdownAppclient(String archive, OutputStream os) throws IOException, InterruptedException {
        File killFile = new File(AppclientHelper.getKillFileName(archive));
        killFile.createNewFile();
        try {
            if (!AppclientHelper.awaitOutput(os, "stopped in")) {
                throw new RuntimeException("Cannot undeploy " + AppclientHelper.getAppclientFullName(archive) + " from appclient");
            }
        }
        finally {
            if (!killFile.delete()) {
                killFile.deleteOnExit();
            }
        }
    }

    private static boolean awaitOutput(OutputStream os, String patternToMatch) throws InterruptedException {
        int countOfAttempts = 0;
        int maxCountOfAttempts = TIMEOUT * 2;
        while (!os.toString().contains(patternToMatch)) {
            Thread.sleep(500L);
            if (countOfAttempts++ != maxCountOfAttempts) continue;
            return false;
        }
        return true;
    }

    private static String getKillFileName(String archive) {
        int sharpIndex = archive.indexOf(35);
        return JBOSS_HOME + FS + "bin" + FS + archive.substring(sharpIndex + 1) + ".kill";
    }

    private static String getAppclientOutputDir() {
        if (appclientOutputDir == null) {
            appclientOutputDir = System.getProperty("appclient.output.dir");
            if (appclientOutputDir == null) {
                throw new IllegalStateException("System property appclient.output.dir not configured");
            }
            File appclientOutputDirectory = new File(appclientOutputDir);
            if (!appclientOutputDirectory.exists() && !appclientOutputDirectory.mkdirs()) {
                throw new IllegalStateException("Unable to create directory " + appclientOutputDir);
            }
        }
        return appclientOutputDir;
    }

    private static String getAppclientFullName(String archive) {
        int sharpIndex = archive.indexOf(35);
        String earName = archive.substring(0, sharpIndex);
        return JBossWSTestHelper.getArchiveFile(earName).getParent() + FS + archive;
    }

    private static String getAppclientShortName(String archive) {
        int sharpIndex = archive.indexOf(35);
        return archive.substring(sharpIndex + 1);
    }

    private static String getAppclientEarName(String archive) {
        int sharpIndex = archive.indexOf(35);
        return archive.substring(0, sharpIndex);
    }

    private static class AppclientDaemonFactory
    implements ThreadFactory {
        static final AppclientDaemonFactory INSTANCE = new AppclientDaemonFactory();
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        AppclientDaemonFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "appclient-output-processing-daemon-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }

    private static class AppclientProcess {
        public Process process;
        public CopyJob outTask;
        public CopyJob errTask;
        public OutputStream output;
        public OutputStream log;

        private AppclientProcess() {
        }
    }
}

