/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import org.jboss.wsf.test.JBossWSTestHelper;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IgnoreContainer
implements TestRule {
    private final String ignoreReason;
    private final String[] ignoredContainers;

    public IgnoreContainer(String ignoreReason, String ... containers) {
        this.ignoreReason = ignoreReason;
        if (containers == null || containers.length == 0) {
            throw new IllegalArgumentException("Expected at least a container version!");
        }
        this.ignoredContainers = containers;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){
            boolean ignored = false;

            public void evaluate() throws Throwable {
                for (String container : IgnoreContainer.this.ignoredContainers) {
                    if (!JBossWSTestHelper.getIntegrationTarget().startsWith(container)) continue;
                    this.ignored = true;
                    break;
                }
                Assume.assumeFalse((String)IgnoreContainer.this.ignoreReason, (boolean)this.ignored);
                base.evaluate();
            }
        };
    }
}

