/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IgnoreJdk
implements TestRule {
    public static final IgnoreJdk IBM8 = new IgnoreJdk("IBM Corporation", "1.8");
    private String vendor;
    private String version;

    public IgnoreJdk(String vendor) {
        this(vendor, null);
    }

    public IgnoreJdk(String vendor, String version) {
        this.vendor = vendor;
        this.version = version;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){
            boolean ignored = false;

            public void evaluate() throws Throwable {
                String jdkVersion = System.getProperty("java.version", "0");
                String jdkVendor = System.getProperty("java.vendor", "UNKNOWN");
                if (IgnoreJdk.this.vendor != null && jdkVendor.contains(IgnoreJdk.this.vendor) && (IgnoreJdk.this.version == null || jdkVersion.startsWith(IgnoreJdk.this.version))) {
                    this.ignored = true;
                }
                Assume.assumeFalse((String)(description.getClassName() + " is excluded for JDK (" + IgnoreJdk.this.vendor + (String)(IgnoreJdk.this.version == null ? "" : ", " + IgnoreJdk.this.version) + ")"), (boolean)this.ignored);
                base.evaluate();
            }
        };
    }
}

